#include "cp_types.h"
#include "cp_proto.h"

/* normalize eucl packing using various options. 
   a: specified eucl area
   u: designated vert on unit circle 
   c: designated vert to prescribed radius
   h: rotate so designated verts in horizontal line
Return 0 on error. */ 

/* fixup: there are a bunch of "normalization" routines. These
   might be better organized. */

int e_norm_scale(struct p_data *p,char *datastr)
{
  int j,v,w,hits;
  double factor=1.0,ctr,rad,x,area=0.0,ang;
  complex z;
  char *nextpoint,next[BUFSIZE],*endptr;
  struct Vertlist *vertlist;
  struct R_data *pR_ptr;

  nextpoint=datastr;

  /* must be euclidean, must have command */
  if ( !p->status || p->hes>0 || p->hes<0) return 0;
  if (!grab_next(&nextpoint,next) || next[0]!='-') return 0;

  pR_ptr=p->packR_ptr;

  switch(next[1])
    {
case 'a': /* scale to given area. */
  /* fixup: Should also take account of inversive distances */
  {
    if (!sscanf(nextpoint,"%lf",&x) || x<.000001)
      return 0;
    area=0.0;
    for (j=1;j<=p->facecount;j++)
      area += e_area(pR_ptr[p->faces[j].vert[0]].rad,
		     pR_ptr[p->faces[j].vert[1]].rad,
		     pR_ptr[p->faces[j].vert[2]].rad);
    factor=sqrt(x/area);
    return eucl_scale(p,factor);
  }
case 'u': /* put designated vert on unit circle */
  {
    if (!(v=grab_one_vert(p,&nextpoint)))
      return 0;
    ctr=cAbs(p->packR_ptr[v].center);
    if (ctr < okerr) return 0;
    factor=1.0/ctr;
    return eucl_scale(p,factor);
  }
case 'c': /* scale v to prescribed radius */
  {
    if (!(v=grab_one_vert(p,&nextpoint))
	|| sscanf(nextpoint,"%lf",&rad)!=1
	|| rad<=okerr || p->packR_ptr[v].rad<okerr) return 0;
    factor=rad/p->packR_ptr[v].rad;
    return eucl_scale(p,factor);
  }
case 'h': /* v --> w horizontal, left to right */
  {
    if (!(vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
	&Vlist,&Elist,&Flist,&region,pathlist,pathlength))
	|| !(vertlist->next) 
	|| (v=vertlist->v)==(w=vertlist->next->v))
      return 0;
    z=csub(p->packR_ptr[w].center,p->packR_ptr[v].center);
    ang=(-1.0)*(Arg(z));
    return (rotate(p,ang));
  }
    } /* end of switch */
  return 0;
} /* e_norm_scale */

