#include "cp_types.h"
#include "cp_proto.h"

/*  Flattening jagged edge of hex packing by introducing 
special overlaps. Each v must be bdry vert, have 3 nghbs. 
Introduces 2*pi/3 overlap with interior neighbor and pi/3 
overlap with each bdry nghb. Results in flat edge at v. */

int flat_hex(struct p_data *p,char *datastr)
{ 
  char *endptr;
  int count=0,v,hits;
  struct Vertlist *vertlist,*trace;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  if (p->hes!=0) return 0;
  if ( (vertlist=Node_link_parse(p,datastr,&endptr,&hits,
		 &Vlist,&Elist,&Flist,&region,pathlist,pathlength)) != NULL)
    {
      trace=vertlist;
      while (trace)
	{
	  v=trace->v;
	  if (pK_ptr[v].bdry_flag && pK_ptr[v].num==2)
	    {
	      if (!p->overlap_status && !alloc_overlaps(p))
		{
		  vert_free(&vertlist);
		  return 0;
		}
	      set_overlap(p,v,1,-0.5);  /* overlap 2*pi/3 */
	      set_overlap(p,v,0,0.5); /* overlap pi/3 */
	      set_overlap(p,v,2,0.5); /* overlap pi/3 */
	      count++;
	    }
	  trace=trace->next;
	}
      vert_free(&vertlist);
      return count;
    }
  return 0;
} /* flat_hex */



