#include "cp_types.h"
#include "cp_proto.h"

/* given 2 hyp centers/s_radii and s_radius of third, return hyp 
center and s_radius for third. oj is cos of overlap angle opposite 
to circle j. There is no consistency check on first two circles 
or incompat's. iflag flags incompats (but not yet passed back). 
Return 0 if there's an arithmetic error. */

int h_compcenter(complex z1,complex z2,complex *z3,
		 double s1,double s2,double *s3,
		 double o1,double o2,double o3)
{
	int iflag=0;
	double flag=1,cc,rad,ahc,sc,s,ac,r,side_p1,ss1,ss3;
	double s413,acstuff;
	complex a,b,c,w1,w2,w3;

	a=z1;
	b=z2;
	if ((s1<=0) && (s2>0)) /* second circle finite, first not */
	 {
		a=z2; b=z1; s=s1; s1=s2; s2=s; s=o1; o1=o2; o2=s; flag=(-1); 
			/* interchange order */
	 }
	if (s1>0) /* first is now finite */
	 {
		cc=h_cos_overlap(s1,s2,*s3,o1,o2,o3,&iflag);
		z3->re=cc;
		z3->im=flag*sqrt(1-cc*cc);
		if (*s3>0)
		 {
			ss1=s1*s1;
			ss3=(*s3)*(*s3);
			if ( (s413=4.0*s1*(*s3))<okerr 
			    || isnan((acstuff=acosh(((1+ss3)*(1+ss1)
				+(1-ss3)*(1-ss1)*o2)/s413))) )
			  return 0;
			side_p1=1.0 + exp(acstuff);
			if (side_p1<okerr) 
			  return 0;
			ahc=(side_p1-2.0)/(side_p1); /* abs value of hyp 
							center */
			z3->re *= ahc;
			z3->im *= ahc; /* center as if z1 at origin */
			*z3=mob_norm_inv(*z3,a,b);   /* move to right place */
			return (1);
		 }
		r=(1-s1)/(1+s1);
		sc=(r*r+1+2*r*o2)/(2*(1+r*o2));
			/* abs value of eucl center c of third circle */
		c.re=sc*z3->re;
		c.im=sc*z3->im;
		rad=1-sc; /* Now have c and its radius */
		w1.re=c.re-rad;
		w1.im=c.im;
		w2.re=c.re+rad;
		w2.im=c.im;
		w3.re=c.re;
		w3.im=c.im+rad; /* three points on the circle */
		w1=mob_norm_inv(w1,a,b);
		w2=mob_norm_inv(w2,a,b);
		w3=mob_norm_inv(w3,a,b);       /* 3 pts on new circle */
		circle_3(w1,w2,w3,&c,&rad);
	 	*s3=(-rad); /* store neg of eucl radius as s_rad */
		ac=cAbs(c);
		z3->re=c.re/ac;
		z3->im=c.im/ac; /* get hyp center on unit circle */
		return (1);
	 } 
/* remaining case: first two are horocycles. Expect -eucl radius as
s-rad of target circle. */
	if (*s3<0 && *s3<=(-1.0)) /* s-rad not valid eucl rad */
	  return 0; 
	return h_horo_center(z1,z2,z3,s1,s2,s3,o1,o2,o3);
} /* h_compcenter */

