#include "cp_types.h"
#include "cp_proto.h"

/* chk sign of deriv of sph angle sum at i, rad=r. */

int s_deriv_sign(struct p_data *p,int i,double r)
{
  int n,neg_term=0;
  double r1,r2,deriv=0,top,bottom;
  struct R_data *pR_ptr;
  struct K_data *pK_ptr;

  pR_ptr=p->packR_ptr;
  pK_ptr=p->packK_ptr;
	
  for (n=0 ;n<=pK_ptr[i].num-1;n++)
    if ((2*r + pR_ptr[pK_ptr[i].flower[n]].rad + 
	 pR_ptr[pK_ptr[i].flower[n+1]].rad)>=M_PI)
      neg_term++;
  if (!neg_term) return -1;
  for (n=0;n<=pK_ptr[i].num-1;n++)
    {
      r1=pR_ptr[pK_ptr[i].flower[n]].rad;
      r2=pR_ptr[pK_ptr[i].flower[n]].rad;
      top=sin(2*r + r1 +r2)*sqrt(sin(r1)*sin(r2));
      bottom=sin(r+r1)*sin(r+r2)*sqrt(sin(r+r1+r2)*sin(r));
      deriv += top/bottom;
    }
  if (deriv >= 0) return -1;
  return 1;
} /* s_deriv_sign */





