/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"

extern char global_hwaddr[1024];
extern char global_ipaddr[1024];
extern char global_hostname[1024];

extern char DHCPD_CONF_BUF[1024];
extern int MAX_CONF_LINE;

#include "allocate.h"
#include "show_info.h"
#include "reread_conf.h"


void delete_host(struct w *widgets)
{
    FILE *fp;
    long conf_size=0;
    int found_host=0;
    char *line;
    char *new_conf;
    gchar *info;

    /* 3 different styles ...\n{ or ...{ or ... { */
    gchar *scope_line1 = g_strdup_printf("host %s\n", global_hostname);
    gchar *scope_line2 = g_strdup_printf("host %s{\n", global_hostname);
    gchar *scope_line3 = g_strdup_printf("host %s {\n", global_hostname);

    if( strlen(global_hostname)==0 || strlen(global_ipaddr)==0 || strlen(global_hwaddr)==0 )
    {
       info = g_strdup_printf(_("Delete host: missing values, host not deleted\n"));
       show_info(info);
       g_free(info);
       return;
    }

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    new_conf = allocate(conf_size+1);

    line = allocate(conf_size+1);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( ( !strcmp(line, scope_line1) || !strcmp(line, scope_line2) 
	|| !strcmp(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    found_host=1;
	
	    while(fgets(line, conf_size, fp)!=NULL)
	    {

		if( strstr(line, "}") && ! strstr(line, "#") )
		  break;
	    }
	}
	else
	  strcat(new_conf, line);
    }
    fclose(fp);

    if( found_host )
    {
	if((fp=fopen(DHCPD_CONF_BUF, "w+"))==NULL)
	{
    	    printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
    	    return;
	}
	else
          {
             fputs(new_conf, fp);
	     fclose(fp);
	  }
    }

    free(new_conf);
    free(line);

    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
}
