/* bprefs.c
 *
 * Copyright (C) 2002 by Jason Day
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"

#include <stdio.h>

#include "libplugin.h"
#include "bprefs.h"
#include "backup.h"

static const char RCSID[] = "$Id: bprefs.c,v 1.4 2009-02-22 08:32:16 rousseau Exp $";


#define NUM_BPREFS 4
static prefType backup_prefs[NUM_BPREFS] = {
    {"backup_when",        INTTYPE,  INTTYPE,  EVERY_SYNC, NULL, 0},
    {"backup_new",         INTTYPE,  INTTYPE,  1,          NULL, 0},
    {"num_archives",       INTTYPE,  INTTYPE,  3,          NULL, 0},
    {"persistent_archive", INTTYPE,  INTTYPE,  0,          NULL, 0}
};


void backup_prefs_init() {
    jp_pref_init (backup_prefs, NUM_BPREFS);
}

int backup_get_pref (int which, long *n, const char **string) {
    if (which > NUM_BPREFS) {
        return -1;
    }

    return jp_get_pref (backup_prefs, which, n, string);
}

int backup_set_pref (int which, long n, const char *string) {
    int rval;

    if (which > NUM_BPREFS) {
        return -1;
    }

    /* Save the prefs file after setting any pref */
    rval = jp_set_pref (backup_prefs, which, n, string);
    if (rval != -1) {
        backup_save_prefs();
    }

    return rval;
}

int backup_load_prefs() {
    return jp_pref_read_rc_file (PREFS_FILE, backup_prefs, NUM_BPREFS);
}

int backup_save_prefs() {
    return jp_pref_write_rc_file (PREFS_FILE, backup_prefs, NUM_BPREFS);
}

void backup_free_prefs() {
    jp_free_prefs (backup_prefs, NUM_BPREFS);
}
