/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.spi.repository;

import java.net.URI;

/**
 * Mirror the OBR RepositoryAdmin interface with URI instead of URL.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 65457 $
 */
public interface RepositoryAdmin
{
    /**
     * Discover any resources that match the given filter.
     *
     * This is not a detailed search, but a first scan of applicable resources.
     *
     * ### Checking the capabilities of the filters is not possible because that     * requires a new construct in the filter.
     *
     * The filter expression can assert any of the main headers of the resource.     * The attributes that can be checked are:
     *
     * <ol>
     * <li>name</li>
     * <li>version (uses filter matching rules)</li>
     * <li>description</li>
     * <li>category</li>
     * <li>copyright</li>
     * <li>license</li>
     * <li>source</li>
     * </ol>
     *
     * @param filterExpr
     *            A standard OSGi filter
     * @return List of resources matching the filters.
     */
    Resource[] discoverResources(String filterExpr);

    /**
     * Create a resolver.
     *
     * @param resource
     * @return
     */
    Resolver resolver();

    /**
     * Add a new repository to the federation.
     *
     * The url must point to a repository XML file.
     *
     * @param repository
     * @return
     * @throws Exception
     */
    Repository addRepository(URI repository) throws Exception;

    /**
     * The OBR version does not include this.
     * 
     * @param repository
     * @return the Repository instance for the 
     * @throws Exception
     */
    Repository getRepository(URI repository) throws Exception;

    boolean removeRepository(URI repository);

    /**
     * List all the repositories.
     *
     * @return
     */
    Repository[] listRepositories();

    Resource getResource(String respositoryId);
}
