/**********************************************************************
 *
 *    FILE:            VisibilityGroup.cpp
 *
 *    DESCRIPTION:    Read/Write osgSim::VisibilityGroup in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator.exe
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 27.11.2003
 *
 **********************************************************************/

#include "Exception.h"
#include "VisibilityGroup.h"
#include "Group.h"

using namespace ive;

void VisibilityGroup::write(DataOutputStream* out){
    // Write VisibilityGroup's identification.
    out->writeInt(IVEVISIBILITYGROUP);
    // If the osgSim class is inherited by any other class we should also write this to file.
    osg::Group*  group = dynamic_cast<osg::Group*>(this);
    if(group){
        ((ive::Group*)(group))->write(out);
    }
    else
        throw Exception("VisibilityGroup::write(): Could not cast this osgSim::VisibilityGroup to an osg::Group.");

    // Write VisibilityGroup's properties.
    out->writeNode(getVisibilityVolume());
    out->writeUInt(getVolumeIntersectionMask());
    out->writeFloat(getSegmentLength());
}

void VisibilityGroup::read(DataInputStream* in){
    // Peek on VisibilityGroup's identification.
    int id = in->peekInt();
    if(id == IVEVISIBILITYGROUP){
        // Read VisibilityGroup's identification.
        id = in->readInt();
        // If the osgSim class is inherited by any other class we should also read this from file.
        osg::Group*  group = dynamic_cast<osg::Group*>(this);
        if(group){
            ((ive::Group*)(group))->read(in);
        }
        else
            throw Exception("VisibilityGroup::read(): Could not cast this osgSim::VisibilityGroup to an osg::Group.");
        // Read VisibilityGroup's properties
        setVisibilityVolume(in->readNode());
        setVolumeIntersectionMask(in->readUInt());
        setSegmentLength(in->readFloat());
    }
    else{
        throw Exception("VisibilityGroup::read(): Expected VisibilityGroup identification.");
    }
}
