// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-

// Copyright (c) 2001-2008 XORP, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software")
// to deal in the Software without restriction, subject to the conditions
// listed in the XORP LICENSE file. These conditions include: you must
// preserve this copyright notice, and you cannot mention the copyright
// holders in advertising related to the Software without their permission.
// The Software is provided WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED. This
// notice is a summary of the XORP LICENSE file; the license in that file is
// legally binding.

// $XORP: xorp/fea/data_plane/fibconfig/fibconfig_table_observer_rtmv2.hh,v 1.6 2008/07/23 05:10:22 pavlin Exp $

#ifndef __FEA_DATA_PLANE_FIBCONFIG_FIBCONFIG_TABLE_OBSERVER_RTMV2_HH__
#define __FEA_DATA_PLANE_FIBCONFIG_FIBCONFIG_TABLE_OBSERVER_RTMV2_HH__

#include "fea/fibconfig_table_observer.hh"
#include "fea/data_plane/control_socket/windows_rtm_pipe.hh"

class WinRtmPipe;
class RtmV2Observer;


class FibConfigTableObserverRtmV2 : public FibConfigTableObserver {
public:
    /**
     * Constructor.
     *
     * @param fea_data_plane_manager the corresponding data plane manager
     * (@ref FeaDataPlaneManager).
     */
    FibConfigTableObserverRtmV2(FeaDataPlaneManager& fea_data_plane_manager);

    /**
     * Virtual destructor.
     */
    virtual ~FibConfigTableObserverRtmV2();

    /**
     * Start operation.
     * 
     * @param error_msg the error message (if error).
     * @return XORP_OK on success, otherwise XORP_ERROR.
     */
    virtual int start(string& error_msg);
    
    /**
     * Stop operation.
     * 
     * @param error_msg the error message (if error).
     * @return XORP_OK on success, otherwise XORP_ERROR.
     */
    virtual int stop(string& error_msg);
    
    /**
     * Receive data from the underlying system.
     * 
     * @param buffer the buffer with the received data.
     */
    virtual void receive_data(const vector<uint8_t>& buffer);
    
private:
    class RtmV2Observer : public WinRtmPipeObserver {
    public:
    	RtmV2Observer(WinRtmPipe& rs, int af,
		      FibConfigTableObserverRtmV2& rtmo)
	    : WinRtmPipeObserver(rs), _af(af), _rtmo(rtmo) {}
    	virtual ~RtmV2Observer() {}
	void routing_socket_data(const vector<uint8_t>& buffer) {
	    _rtmo.receive_data(buffer);
	}
    private:
	int _af;
    	FibConfigTableObserverRtmV2& _rtmo;
    };

    WinRtmPipe*		_rs4;
    RtmV2Observer*	_rso4;
    WinRtmPipe*		_rs6;
    RtmV2Observer*	_rso6;
};

#endif // __FEA_DATA_PLANE_FIBCONFIG_FIBCONFIG_TABLE_OBSERVER_RTMV2_HH__
