/*
 * Copyright (c) 2001-2008 XORP, Inc.
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/redist_transaction6_xif.cc,v 1.17 2008/07/23 05:11:58 pavlin Exp $"

#include "redist_transaction6_xif.hh"

bool
XrlRedistTransaction6V0p1Client::send_start_transaction(
	const char*	dst_xrl_target_name,
	const StartTransactionCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "redist_transaction6/0.1/start_transaction");
    return _sender->send(x, callback(this, &XrlRedistTransaction6V0p1Client::unmarshall_start_transaction, cb));
}


/* Unmarshall start_transaction */
void
XrlRedistTransaction6V0p1Client::unmarshall_start_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	StartTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t tid;
    try {
	a->get("tid", tid);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &tid);
}

bool
XrlRedistTransaction6V0p1Client::send_commit_transaction(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const CommitTransactionCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "redist_transaction6/0.1/commit_transaction");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlRedistTransaction6V0p1Client::unmarshall_commit_transaction, cb));
}


/* Unmarshall commit_transaction */
void
XrlRedistTransaction6V0p1Client::unmarshall_commit_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	CommitTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRedistTransaction6V0p1Client::send_abort_transaction(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const AbortTransactionCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "redist_transaction6/0.1/abort_transaction");
    x.args().add("tid", tid);
    return _sender->send(x, callback(this, &XrlRedistTransaction6V0p1Client::unmarshall_abort_transaction, cb));
}


/* Unmarshall abort_transaction */
void
XrlRedistTransaction6V0p1Client::unmarshall_abort_transaction(
	const XrlError&	e,
	XrlArgs*	a,
	AbortTransactionCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRedistTransaction6V0p1Client::send_add_route(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const IPv6&	nexthop,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	cookie,
	const string&	protocol_origin,
	const AddRouteCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "redist_transaction6/0.1/add_route");
    x.args().add("tid", tid);
    x.args().add("dst", dst);
    x.args().add("nexthop", nexthop);
    x.args().add("ifname", ifname);
    x.args().add("vifname", vifname);
    x.args().add("metric", metric);
    x.args().add("admin_distance", admin_distance);
    x.args().add("cookie", cookie);
    x.args().add("protocol_origin", protocol_origin);
    return _sender->send(x, callback(this, &XrlRedistTransaction6V0p1Client::unmarshall_add_route, cb));
}


/* Unmarshall add_route */
void
XrlRedistTransaction6V0p1Client::unmarshall_add_route(
	const XrlError&	e,
	XrlArgs*	a,
	AddRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRedistTransaction6V0p1Client::send_delete_route(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const IPv6Net&	dst,
	const IPv6&	nexthop,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	metric,
	const uint32_t&	admin_distance,
	const string&	cookie,
	const string&	protocol_origin,
	const DeleteRouteCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "redist_transaction6/0.1/delete_route");
    x.args().add("tid", tid);
    x.args().add("dst", dst);
    x.args().add("nexthop", nexthop);
    x.args().add("ifname", ifname);
    x.args().add("vifname", vifname);
    x.args().add("metric", metric);
    x.args().add("admin_distance", admin_distance);
    x.args().add("cookie", cookie);
    x.args().add("protocol_origin", protocol_origin);
    return _sender->send(x, callback(this, &XrlRedistTransaction6V0p1Client::unmarshall_delete_route, cb));
}


/* Unmarshall delete_route */
void
XrlRedistTransaction6V0p1Client::unmarshall_delete_route(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRedistTransaction6V0p1Client::send_delete_all_routes(
	const char*	dst_xrl_target_name,
	const uint32_t&	tid,
	const string&	cookie,
	const DeleteAllRoutesCB&	cb
)
{
    Xrl x(dst_xrl_target_name, "redist_transaction6/0.1/delete_all_routes");
    x.args().add("tid", tid);
    x.args().add("cookie", cookie);
    return _sender->send(x, callback(this, &XrlRedistTransaction6V0p1Client::unmarshall_delete_all_routes, cb));
}


/* Unmarshall delete_all_routes */
void
XrlRedistTransaction6V0p1Client::unmarshall_delete_all_routes(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteAllRoutesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
