/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.ServiceDescriptor;
import IceGridGUI.Application.CommunicatorSubEditor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import javax.swing.JTextField;

class ServiceSubEditor
extends CommunicatorSubEditor {
    private JTextField _name = new JTextField(20);
    private JTextField _entry = new JTextField(20);

    ServiceSubEditor(Editor mainEditor) {
        super(mainEditor);
        this._name.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._name.setToolTipText("Identifies this service within an IceBox server");
        this._entry.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._entry.setToolTipText("<html>The service entry point and optional arguments.<br>C++: <i>shared object:function-name arg1 arg2 ...</i><br>Java: <i>class-name arg1 arg2 ...</i><br>C#, Visual Basic: <i>assembly:class-name arg1 arg2 ...</i></html>");
    }

    ServiceDescriptor getServiceDescriptor() {
        return (ServiceDescriptor)this._mainEditor.getSubDescriptor();
    }

    void appendProperties(DefaultFormBuilder builder) {
        builder.append("Service Name");
        builder.append((Component)this._name, 3);
        builder.nextLine();
        super.appendProperties(builder);
        builder.append("Entry Point");
        builder.append((Component)this._entry, 3);
        builder.nextLine();
    }

    void writeDescriptor() {
        ServiceDescriptor descriptor = this.getServiceDescriptor();
        descriptor.name = this._name.getText().trim();
        descriptor.entry = this._entry.getText().trim();
        super.writeDescriptor(descriptor);
    }

    boolean isSimpleUpdate() {
        return this.getServiceDescriptor().name.equals(this._name.getText().trim());
    }

    boolean validate() {
        return this._mainEditor.check(new String[]{"Service Name", this._name.getText().trim(), "Entry Point", this._entry.getText().trim()});
    }

    void show(boolean isEditable) {
        ServiceDescriptor descriptor = this.getServiceDescriptor();
        Utils.Resolver detailResolver = this._mainEditor.getDetailResolver();
        boolean bl = isEditable = isEditable && detailResolver == null;
        if (detailResolver != null) {
            this._name.setText(detailResolver.find("service"));
        } else {
            this._name.setText(descriptor.name);
        }
        this._name.setEditable(isEditable);
        this._entry.setText(Utils.substitute(descriptor.entry, detailResolver));
        this._entry.setEditable(isEditable);
        this.show(descriptor, isEditable);
    }
}

