/*
 * Decompiled with CFR 0.152.
 */
package IceUtil;

import java.nio.ByteBuffer;

public class Base64 {
    public static String encode(byte[] plainSeq) {
        if (plainSeq == null || plainSeq.length == 0) {
            return "";
        }
        StringBuffer retval = new StringBuffer();
        int base64Bytes = plainSeq.length * 4 / 3 + 1;
        int newlineBytes = base64Bytes * 2 / 76 + 1;
        int totalBytes = base64Bytes + newlineBytes;
        retval.ensureCapacity(totalBytes);
        for (int i = 0; i < plainSeq.length; i += 3) {
            int by1 = plainSeq[i] & 0xFF;
            int by2 = 0;
            int by3 = 0;
            if (i + 1 < plainSeq.length) {
                by2 = plainSeq[i + 1] & 0xFF;
            }
            if (i + 2 < plainSeq.length) {
                by3 = plainSeq[i + 2] & 0xFF;
            }
            int by4 = by1 >> 2 & 0xFF;
            int by5 = ((by1 & 3) << 4 | by2 >> 4) & 0xFF;
            int by6 = ((by2 & 0xF) << 2 | by3 >> 6) & 0xFF;
            int by7 = by3 & 0x3F;
            retval.append(Base64.encode((byte)by4));
            retval.append(Base64.encode((byte)by5));
            if (i + 1 < plainSeq.length) {
                retval.append(Base64.encode((byte)by6));
            } else {
                retval.append('=');
            }
            if (i + 2 < plainSeq.length) {
                retval.append(Base64.encode((byte)by7));
                continue;
            }
            retval.append('=');
        }
        StringBuffer outString = new StringBuffer();
        outString.ensureCapacity(totalBytes);
        int iter = 0;
        while (retval.length() - iter > 76) {
            outString.append(retval.substring(iter, 76));
            outString.append("\r\n");
            iter += 76;
        }
        outString.append(retval.substring(iter));
        return outString.toString();
    }

    public static byte[] decode(String str) {
        StringBuffer newStr = new StringBuffer();
        newStr.ensureCapacity(str.length());
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (!Base64.isBase64(c)) continue;
            newStr.append(c);
        }
        if (newStr.length() == 0) {
            return null;
        }
        int totalBytes = newStr.length() * 3 / 4 + 1;
        ByteBuffer retval = ByteBuffer.allocate(totalBytes);
        int pos = 0;
        for (int i = 0; i < newStr.length(); i += 4) {
            char c1 = 'A';
            char c2 = 'A';
            char c3 = 'A';
            char c4 = 'A';
            c1 = newStr.charAt(i);
            if (i + 1 < newStr.length()) {
                c2 = newStr.charAt(i + 1);
            }
            if (i + 2 < newStr.length()) {
                c3 = newStr.charAt(i + 2);
            }
            if (i + 3 < newStr.length()) {
                c4 = newStr.charAt(i + 3);
            }
            int by1 = Base64.decode(c1) & 0xFF;
            int by2 = Base64.decode(c2) & 0xFF;
            int by3 = Base64.decode(c3) & 0xFF;
            int by4 = Base64.decode(c4) & 0xFF;
            retval.put((byte)(by1 << 2 | by2 >> 4));
            ++pos;
            if (c3 != '=') {
                retval.put((byte)((by2 & 0xF) << 4 | by3 >> 2));
                ++pos;
            }
            if (c4 == 61) continue;
            retval.put((byte)((by3 & 3) << 6 | by4));
            ++pos;
        }
        byte[] arr = new byte[pos];
        System.arraycopy(retval.array(), 0, arr, 0, pos);
        return arr;
    }

    public static boolean isBase64(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c == '+') {
            return true;
        }
        if (c == '/') {
            return true;
        }
        return c == '=';
    }

    private static char encode(byte uc) {
        if (uc < 26) {
            return (char)(65 + uc);
        }
        if (uc < 52) {
            return (char)(97 + (uc - 26));
        }
        if (uc < 62) {
            return (char)(48 + (uc - 52));
        }
        if (uc == 62) {
            return '+';
        }
        return '/';
    }

    private static byte decode(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (byte)(c - 65);
        }
        if (c >= 'a' && c <= 'z') {
            return (byte)(c - 97 + 26);
        }
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48 + 52);
        }
        if (c == '+') {
            return 62;
        }
        return 63;
    }
}

