/* urltables.h
 * Part of ziproxy package
 *
 * Copyright (c)2005-2008 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Routines for URL lookup from tables (for use with ACLs etc)
 */

//To stop multiple inclusions.
#ifndef SRC_URLTABLES_H
#define SRC_URLTABLES_H

#include "strtables.h"

// public
typedef struct {
	t_st_strtable *host;    // private
	t_st_strtable *url;	// private
} t_ut_urltable;

extern t_ut_urltable *ut_create (void);
extern void ut_destroy (t_ut_urltable *ut_urltable);
extern void ut_insert (t_ut_urltable *ut_urltable, const char *host, const char *path);
extern int ut_check_if_matches (const t_ut_urltable *ut_urltable, const char *host, const char *path);
extern t_ut_urltable *ut_create_populate_from_file (const char *filename);

#endif

