/*
  Copyright (C) 1999, 2000 Lorenzo Bettini <lorenzo.bettini@penteres.it>
  All rights reserved.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* cmdline.c */

#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_GETOPT_LONG
#include <getopt.h>
#else
#include "getopt.h"
#endif /* HAVE_GETOPT_LONG */

#ifndef HAVE_STRDUP

char *strdup( const char *s ) ;

char *
strdup( const char *s )
{
  char *res ;

  res = (char *) malloc( strlen( s ) + 1 ) ;
  strcpy( res, s ) ;

  return res ;
}

#else /* HAVE_STRDUP */

#include <string.h>

#endif /* HAVE_STRDUP */

#include "cmdline.h"

int
cmdline ( int argc, char **argv, cmdline_info *cmdinfo )
{
  int c;
  int digit_optind = 0;
  
  while (1)
    {
      int this_option_optind = optind ? optind : 1;
      int option_index = 0;
      static struct option long_options[] =
      {
        {"verbose", 0, 0, 'v'},
	{"help", 0, 0, 'h'},
        {"tab", 1, 0, 't'},
        {"doc", 0, 0, 'd'},
        {"css", 1, 0, 'c'},
        {"title", 1, 0, 'T'},
        {"input", 1, 0, 'i'},
	{"output", 1, 0, 'o'},
	{"version", 0, 0, 'V'},
        {0, 0, 0, 0}
      };
      
      c = getopt_long (argc, argv, "vht:dc:T:i:o:V",
                       long_options, &option_index);
      if (c == -1)
        break;
      
      switch (c)
        {
        case 'v':
	  cmdinfo->verbose = 1 ;
          break;
          
        case 'h':
	  cmdinfo->help = 1 ;
          break;
          
        case 't':
	  cmdinfo->tab = atoi( optarg ) ;
          break;
          
        case 'd':
	  cmdinfo->doc = 1 ;
          break;

	case 'c':
	  if ( optarg )
	    cmdinfo->css = strdup( optarg ) ;
          break;

	case 'T':
	  if ( optarg )
	    cmdinfo->title = strdup( optarg ) ;
          break;

	case 'i':
	  if ( optarg )
	    cmdinfo->input = strdup( optarg ) ;
          break;

	case 'o':
	  if ( optarg )
	    cmdinfo->output = strdup( optarg ) ;
          break;
          
	case 'V':
	  cmdinfo->version = 1 ;
          break;

        case '?':
          break;
          
        default:
          fprintf (stderr, "?? getopt returned character code 0%o ??\n", c);
        }
    }
  
  if (optind < argc)
    {
      int i = 0 ;

      cmdinfo->inputs_size = argc - optind ;
      cmdinfo->inputs = 
	(char **)( malloc ( (cmdinfo->inputs_size)*sizeof(char *) ) ) ;

      while (optind < argc)
        cmdinfo->inputs[ i++ ] = strdup (argv[optind++]) ; 
    }

  return -1 ; /* OK */
}
