/* cmdutils.c: 
 *
 ****************************************************************
 * Copyright (C) 2004 Tom Lord
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/safe.h"
#include "hackerlab/char/str.h"
#include "tla/libarch/archive.h"
#include "tla/libarch/namespace.h"
#include "tla/libarch/cmdutils.h"




void
arch_check_for_revision (struct arch_archive * arch, t_uchar * revision)
{
  enum arch_revision_type type;
  int is_cached = 0;

  if (!arch_revision_exists (&type, &is_cached, arch, revision))
    {
      safe_printfmt (2, "No such revision\n  name: %s\n  location: %s\n  revision: %s\n", arch->name, arch->location, revision);
      exit (2);
    }
}


void
arch_check_for_package (struct arch_archive * arch, t_uchar * package)
{
  t_uchar * category = 0;
  t_uchar * branch = 0;
  rel_table categories = 0;
  rel_table branches = 0;
  int x;
  int found_it = 0;

  category = arch_parse_package_name (arch_ret_category, 0, package);
  branch = arch_parse_package_name (arch_ret_package, 0, package);

  categories = arch_archive_categories (arch);
  for (x = 0; x < rel_n_records (categories); ++x)
    {
      if (!str_cmp (category, categories[x][0]))
        break;
    }

  if (x < rel_n_records (categories))
    {
      branches = arch_archive_branches (arch, category);

      for (x = 0; x < rel_n_records (branches); ++x)
        {
          if (!str_cmp (branch, branches[x][0]))
            {
              found_it = 1;
              break;
            }
        }
    }

  if (!found_it)
    {
      safe_printfmt (2, "No such package\n  name: %s\n  location: %s\n  package: %s\n", arch->name, arch->location, package);
      exit (2);
    }

  lim_free (0, category);
  lim_free (0, branch);
  rel_free_table (categories);
  rel_free_table (branches);
}


void
arch_check_for_version (struct arch_archive * arch, t_uchar * version_spec)
{
  t_uchar * branch = 0;
  t_uchar * version = 0;
  rel_table versions = 0;
  int x;
  int found_it = 0;

  branch = arch_parse_package_name (arch_ret_package, 0, version_spec);
  version = arch_parse_package_name (arch_ret_package_version, 0, version_spec);
  versions = arch_archive_versions (arch, branch);

  for (x = 0; x < rel_n_records (versions); ++x)
    {
      if (!str_cmp (version, versions[x][0]))
        {
          found_it = 1;
          break;
        }
    }

  if (!found_it)
    {
      safe_printfmt (2, "No such version\n  name: %s\n  location: %s\n  version: %s\n", arch->name, arch->location, version);
      exit (2);
    }

  lim_free (0, branch);
  lim_free (0, version);
  rel_free_table (versions);
}



/* tag: Aaron Bentley Tue Dec 23 10:46:00 2003 (cmdutils.c)
 */
