/* trim.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/char/char-class.h"
#include "hackerlab/mem/alloc-limits.h"
#include "hackerlab/mem/mem.h"
#include "tla/libawk/trim.h"



t_uchar *
trim_surrounding_ws (t_uchar * str)
{
  t_uchar * pos;
  t_uchar * start_pos;
  t_uchar * end_guess;

  if (!str)
    return 0;

  for (pos = str; char_is_space (*pos); ++pos)
    ;

  start_pos = pos;
  end_guess = 0;

  while (*pos)
    {
      while (*pos && !char_is_space (*pos))
        ++pos;

      end_guess = pos;

      while (char_is_space (*pos))
        ++pos;
    }

  if (!end_guess)
    end_guess = pos;

  mem_move (str, start_pos, (size_t)(end_guess - start_pos));

  str = lim_realloc (0, str, (size_t)(1 + end_guess - start_pos));
  str[(end_guess - start_pos)] = 0;

  return str;
}




/* tag: Tom Lord Tue Jun 10 14:25:44 2003 (trim.c)
 */
