# GNU Enterprise Forms - GTK UI Driver - button widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: button.py 9956 2009-10-11 18:54:57Z reinhard $

import gtk

from gnue.common import events
from gnue.common.apps import GDebug
from gnue.forms.uidrivers.gtk2.widgets._base import UIHelper

# =============================================================================
# This class wraps an UI layer around a gtk.Button widget
# =============================================================================

class UIButton (UIHelper):

  # ---------------------------------------------------------------------------
  # Create a gtk widget
  # ---------------------------------------------------------------------------

  def _create_widget (self, event, spacer):
    object = event.object

    text = "%s" % object.label
    newWidget = gtk.Button (self._makeSafe (text))
    newWidget.set_size_request (self.itemWidth, self.itemHeight)

    if event.initialize:
      newWidget.connect ('clicked', self.buttonHandler)
      self._addDefaultEventHandler (newWidget)
      self._addFocusHandler (newWidget)

    event.container.put (newWidget, self.itemX, self.itemY)
    newWidget.show ()

    return newWidget


  # ---------------------------------------------------------------------------
  # Handle button click signals
  # ---------------------------------------------------------------------------

  def buttonHandler (self, widget):

    gfObject = self._uiDriver._WidgetToGFObj [widget]
    gfObject._event_fire ()


  # ---------------------------------------------------------------------------
  # Enable/disable this button
  # ---------------------------------------------------------------------------

  def _ui_enable_(self, index):
    self.widgets[index].set_sensitive(True)

  # ---------------------------------------------------------------------------

  def _ui_disable_(self, index):
    self.widgets[index].set_sensitive(False)


# -----------------------------------------------------------------------------
# Determine the minimum size of a button widget
# -----------------------------------------------------------------------------

def size_request ():
  """
  This function returns a tuple (width, height) describing the minimum size of
  a button widget. Actually only the height is meaningfull for a button.
  """

  button = gtk.Button ('Foo yeah')
  (w, height) = button.size_request ()
  return (None, height)



# -----------------------------------------------------------------------------
# Configuration data
# -----------------------------------------------------------------------------

configuration = {
  'baseClass'  : UIButton,
  'provides'   : 'GFButton',
  'container'  : 0,
}
