# GNU Enterprise Forms - win32 UI Driver - Menu widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: menu.py 9956 2009-10-11 18:54:57Z reinhard $

import win32gui
import win32con

from gnue.forms.uidrivers.win32.widgets import menuitem
from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Window
from gnue.forms.uidrivers.win32.common import getNextId, textEncode

_menustyle = win32con.MF_STRING


# =============================================================================
# Wrap an UI layer around a Menu widget
# =============================================================================

class UIMenu(UIHelper):
    """
    Implements a menu object.
    """

    # -------------------------------------------------------------------------
    # Create a menu widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new Menu widget.
        """
        if self._gfObject.name == '__main_menu__' \
                and not self._form._features['GUI:MENUBAR:SUPPRESS']:
            # Menu bar of the form
            widget = win32gui.CreateMenu()
            self._container = menuitem.Menu(widget, self._uiForm.mainWindow)
            win32gui.SetMenu(self._uiForm.mainWindow.GetHwnd(), widget )

        else:
            # Submenu or popup menu
            widget = win32gui.CreatePopupMenu()
            if isinstance(event.container, menuitem.Menu):
                label = textEncode(self._gfObject.label) or ''
                win32gui.AppendMenu(event.container.id, _menustyle | win32con.MF_POPUP, widget, label)
            self._container = menuitem.Menu(widget, event.container)
            
        return self._container


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIMenu,
  'provides' : 'GFMenu',
  'container': 1,
}
