/* 
   PXKFunctions.m

   Generic Functions for the GNUstep GUI X/DPS Library.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Author:  Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: September 1996
   
   This file is part of the GNUstep GUI X/DPS Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/ 

#include "config.h"
#include <DPS/psops.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSCStringText.h>
#include <AppKit/NSEvent.h>
#include <gnustep/xdps/NSDPSContextWindow.h>
#include "drawingfuncs.h"
#include "extensions.h"

#define	CUR_CONTEXT	((NSDPSContext*)[NSDPSContext currentContext])

//
// Rectangle Drawing Functions
//
//
// Optimize Drawing
//
void NSEraseRect(NSRect aRect)
{
  PSgsave();
  PSsetgray(1);
  PSrectfill(aRect.origin.x, aRect.origin.y, 
	     aRect.size.width, aRect.size.height);
  PSgrestore();
}

void NSHighlightRect(NSRect aRect)
{
  float x, y, w, h;
  NSDPSContext *ctxt;

  ctxt = (NSDPSContext *)[NSGraphicsContext currentContext];
  x = NSMinX(aRect);
  y = NSMinY(aRect);
  w = NSWidth(aRect);
  h = NSHeight(aRect);
  [ctxt DPScompositerect: x : y : w : h : NSCompositeHighlight];

  [[[ctxt focusView] window] flushWindow];
}

void NSRectClip(NSRect aRect)
{  
  float x, y, w, h;

  x = NSMinX(aRect);
  y = NSMinY(aRect);
  w = NSWidth(aRect);
  h = NSHeight(aRect);

  PSrectclip(x, y, w, h);
  PSnewpath();
}

void NSRectClipList(const NSRect *rects, int count)
{
  int i;
  for (i=0; i<count; i++)
    NSRectClip(rects[i]);
}

void NSRectFill(NSRect aRect)
{
  PSrectfill(aRect.origin.x, aRect.origin.y, 
	     aRect.size.width, aRect.size.height);
}

void NSRectFillList(const NSRect *rects, int count)
{
  int i;

  for (i = 0;i < count; ++i)
    PSrectfill(rects[i].origin.x, rects[i].origin.y, 
	       rects[i].size.width, rects[i].size.height);
}

void NSRectFillListWithGrays(const NSRect *rects, 
			     const float *grays, int count)
{
  int i;

  for (i = 0;i < count; ++i)
    {
      PSsetgray(grays[i]);
      PSrectfill(rects[i].origin.x, rects[i].origin.y, 
		 rects[i].size.width, rects[i].size.height);
    }
}

//
// Draw a Bordered Rectangle
//
void NSDrawButton(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }

  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawButton (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSDrawGrayBezel(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawGrayBezel (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSDrawGroove(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawGroove (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSDrawWhiteBezel(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawWhiteBezel (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSDrawBezel(NSRect rect, NSRect clipRect)
{
  float v;
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  /* The lines drawn should be offset by half a linewidth inwards so
     that the entire line gets drawn inside the rectangle. */
  rect.size.width -= 1;
  rect.size.height -= 1;
  v = 1;
  if ([[GSCurrentContext() focusView] isFlipped])
    {
      rect.origin.y += rect.size.height;
      rect.size.height = -rect.size.height;
      v = -v;
    }
  else
    rect.origin.y++;

  PSWDrawBezel (rect.origin.x, rect.origin.y,
		   rect.size.width, rect.size.height, v);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void GSDrawPressedPushButton(NSRect rect, NSRect clipRect)
{
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  PSWDrawPressedPushButton (rect.origin.x, rect.origin.y,
		       rect.size.width, rect.size.height);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void GSDrawPressedToggleButton(NSRect rect, NSRect clipRect)
{
  if (!NSIsEmptyRect(clipRect) && NSIntersectsRect(rect, clipRect) == NO)
    return;

  if (!NSIsEmptyRect(clipRect))
    {
      PSgsave();
      PSrectclip (clipRect.origin.x, clipRect.origin.y,
		clipRect.size.width, clipRect.size.height);
    }
  PSWDrawPressedToggleButton (rect.origin.x, rect.origin.y,
		       rect.size.width, rect.size.height);
  if (!NSIsEmptyRect(clipRect))
    PSgrestore();
}

void NSFrameRect(NSRect rect)
{
  PSWFrameRect (rect.origin.x, rect.origin.y,
		  rect.size.width, rect.size.height);
}

void NSFrameRectWithWidth(NSRect rect, float frameWidth)
{
  PSWFrameRectWithWidth (rect.origin.x, rect.origin.y,
			   rect.size.width, rect.size.height, frameWidth);
}

NSRect NSDrawTiledRects(NSRect boundsRect, NSRect clipRect, 
			const NSRectEdge *sides, const float *grays, 
			int count)
{
	return NSZeroRect;
}

//
// Read the Color at a Screen Position
//
NSColor *NSReadPixel(NSPoint location)
{
	return nil;
}

//
// Text Functions
//
//
// Filter Characters Entered into a Text Object
//
unsigned short NSEditorFilter(unsigned short theChar, 
			      int flags, NSStringEncoding theEncoding)
{
	return 0;
}

unsigned short NSFieldFilter(unsigned short theChar, 
			     int flags, NSStringEncoding theEncoding)
{
	return 0;
}

//
// Calculate or Draw a Line of Text (in Text Object)
//
int NSDrawALine(id self, NSLayInfo *layInfo)
{
	return 0;
}

int NSScanALine(id self, NSLayInfo *layInfo)
{
	return 0;
}

//
// Calculate Font Ascender, Descender, and Line Height (in Text Object)
//
void NSTextFontInfo(id fid, 
		    float *ascender, float *descender, 
		    float *lineHeight)
{}

//
// Access Text Object's Word Tables
//
NSData * NSDataWithWordTable(const unsigned char *smartLeft,
			     const unsigned char *smartRight,
			     const unsigned char *charClasses,
			     const NSFSM *wrapBreaks,
			     int wrapBreaksCount,
			     const NSFSM *clickBreaks, 
			     int clickBreaksCount, 
			     BOOL charWrap)
{
	return nil;
}

void NSReadWordTable(NSZone *zone,
		     NSData *data,
		     unsigned char **smartLeft,
		     unsigned char **smartRight,
		     unsigned char **charClasses,
		     NSFSM **wrapBreaks,
		     int *wrapBreaksCount,
		     NSFSM **clickBreaks,
		     int *clickBreaksCount, 
		     BOOL *charWrap)
{}

//
// Array Allocation Functions for Use by the NSText Class
//
NSTextChunk *NSChunkCopy(NSTextChunk *pc, NSTextChunk *dpc)
{
	return NULL;
}

NSTextChunk *NSChunkGrow(NSTextChunk *pc, int newUsed)
{
	return NULL;
}

NSTextChunk *NSChunkMalloc(int growBy, int initUsed)
{
	return NULL;
}

NSTextChunk *NSChunkRealloc(NSTextChunk *pc)
{
	return NULL;
}

NSTextChunk *NSChunkZoneCopy(NSTextChunk *pc, 
                             NSTextChunk *dpc,
                             NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneGrow(NSTextChunk *pc, int newUsed, NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneMalloc(int growBy, int initUsed, NSZone *zone)
{
	return NULL;
}

NSTextChunk *NSChunkZoneRealloc(NSTextChunk *pc, NSZone *zone)
{
	return NULL;
}


//
// Imaging Functions
//
//
// Copy an image
//
void NSCopyBitmapFromGState(int srcGstate, NSRect srcRect, NSRect destRect)
{}

void NSCopyBits(int srcGstate, NSRect srcRect, NSPoint destPoint)
{
  XRectangle	dst;
  XRectangle    src;
  Drawable source, draw;
  NSWindow *window;
  NSDPSContext *ctxt;
  gswindow_device_t *windev;

  ctxt = (NSDPSContext *)GSCurrentContext();
  window = [[GSCurrentContext() focusView] window];
  windev = [NSDPSContext _windowWithTag: [window windowNumber]];
  draw = (windev->buffer) ? windev->buffer : windev->ident;
  if (draw == 0)
    return;

      NSDebugLLog (@"CTM", @"Frame  %@\n", NSStringFromRect(windev->xframe));
  source = 0;
  if (srcGstate != 0)
    {
      int gc, x, y;
      PSgsave();
      PSsetgstate(srcGstate);
      PScurrentXgcdrawable(&gc, (int *)(&source), &x, &y);
      if (source == 0)
        return;
      if (source == draw)
	{
	  /* This probably shouldn't happen, It might come from a bug
	     in DGS 0.5.x
	  */
	}
      NSDebugLLog (@"Copy", @"Orig  %@\n", NSStringFromRect(srcRect));
      srcRect = [ctxt XRectFromUserRect: srcRect];
      NSDebugLLog (@"Copy", @"XCoor %@\n", NSStringFromRect(srcRect));
      PSgrestore();
    }
  else
    {
      source = draw;
      srcRect = [ctxt XRectFromUserRect: srcRect];
    }
  NSDebugLLog (@"Copy", @"ODest %@\n", NSStringFromPoint(destPoint));
  destPoint = [ctxt XPointFromUserPoint: destPoint];
  /* FIXME: Why is this needed? */
  if (![[GSCurrentContext() focusView] isFlipped])
    destPoint.y -= NSHeight(srcRect);
  NSDebugLLog (@"Copy", @"XDest %@\n", NSStringFromPoint(destPoint));

  src.x = NSMinX(srcRect); src.y = NSMinY(srcRect);
  src.width = NSWidth(srcRect); src.height = NSHeight(srcRect);
  dst.x = destPoint.x; dst.y = destPoint.y;
  NSDebugLLog (@"NSWindow", @"Copying bitmap from (%d %d %d %d) to (%d %d)\n",
  	src.x, src.y, src.width, src.height, dst.x, dst.y);
  [ctxt wait];
  XCopyArea([ctxt xDisplay], source, draw, windev->gc,
                src.x, src.y, src.width, src.height, dst.x, dst.y);
}

//
// Render Bitmap Images
//

void NSDrawBitmap(NSRect rect,
                  int pixelsWide,
                  int pixelsHigh,
                  int bitsPerSample,
                  int samplesPerPixel,
                  int bitsPerPixel,
                  int bytesPerRow, 
                  BOOL isPlanar,
                  BOOL hasAlpha, 
                  NSString *colorSpaceName, 
                  const unsigned char *const data[5])
{
  int bytes;
  int working_alphaimage;
  DPSContext ctxt;
  ctxt = DPSGetCurrentContext();

  // FIXME
#if 0
  working_alphaimage = [(NSDPSContext *)GSCurrentContext() operatorExtensions]
    & ALPHAIMAGE_EXT;
#else
  working_alphaimage = NO;
#endif

  /* Save scaling */
  PSmatrix(); PScurrentmatrix();
  PSmoveto(NSMinX(rect), NSMinY(rect));
  PSscale(NSWidth(rect), NSHeight(rect));

  if (bitsPerSample == 0)
    bitsPerSample = 8;
  bytes = 
    (bitsPerSample * pixelsWide * pixelsHigh + 7) / 8;
  if (bytes * samplesPerPixel != bytesPerRow * pixelsHigh) 
    {
      NSLog(@"Image Rendering Error: Dodgy bytesPerRow value %d", bytesPerRow);
      NSLog(@"   pixelsHigh=%d, bytes=%d, samplesPerPixel=%d",
	    bytesPerRow, pixelsHigh, bytes);
      return;
    }

  // send the PostScript code
  if(hasAlpha && working_alphaimage == YES) 
    {
      // FIXME
      NSLog(@"Alphaimage not implemented");
      return;
    } 
  else if(samplesPerPixel > 1) 
    {
      if(isPlanar || (hasAlpha && (working_alphaimage == NO))) 
	{
	  if(bitsPerSample != 8) 
	    {
	      NSLog(@"Image format conversion not supported for bps!=8");
	      return;
	    }
	}
      PSWColorImageHeader(pixelsWide, pixelsHigh, 
			  bitsPerSample,
			  hasAlpha?(samplesPerPixel-1):samplesPerPixel);
    } 
  else
    PSWImageHeader(pixelsWide, pixelsHigh, bitsPerSample);
  
  // The context is now waiting for data on its standard input
  if(isPlanar || (hasAlpha && (working_alphaimage == NO))) 
    {
      // We need to do a format conversion.
      // We do this on the fly, sending data to the context as soon as
      // it is computed.
      int i, j, spp, isAlpha, alpha;
      unsigned char val;
      isAlpha = hasAlpha && (working_alphaimage == NO);
      if(isAlpha)
	spp = samplesPerPixel - 1;
      else
	spp = samplesPerPixel;
      
      for(j=0; j<bytes; j++) 
	{
	  if(isAlpha) 
	    {
	      if(isPlanar)
		alpha = data[spp][j];
	      else
		alpha = data[0][spp+j*samplesPerPixel];
	    }
	  for (i = 0; i < spp; i++) 
	    {
	      if(isPlanar)
		val = data[i][j];
	      else
		val = data[0][i+j*samplesPerPixel];
	      if(isAlpha)
		val = 255 - ((255-val)*(long)alpha)/255;
	      DPSWriteData(ctxt, &val, 1);
	    }
	}
    } 
  else 
    {
      // The data is already in the format the context expects it in
      DPSWriteData(ctxt, (char*)data[0], bytes*samplesPerPixel);
    }

  /* Restore original scaling */
  PSsetmatrix();
}

//
// Other Application Kit Functions
//

//
// Play the System Beep
//
void NSBeep(void)
{
  Display *xDisplay = [(NSDPSContext *)[NSDPSContext currentContext]
					xDisplay];

  XBell(xDisplay, 50);
}

//
// Draw a Distinctive Outline around Linked Data
//
void NSFrameLinkRect(NSRect aRect, BOOL isDestination)
{}

float NSLinkFrameThickness(void)
{
	return 0;
}

//
// Convert an Event Mask Type to a Mask
//
unsigned int NSEventMaskFromType(NSEventType type)
{
	return 0;
}
