/* Generic functions common to X backends for GNUstep

   Copyright (C) 2000 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org> (Mostly copied from other places)
   Date: Mar 2000
   
   This file is part of the GNUstep project

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

#ifdef XDPS_BACKEND_LIBRARY
#define XGContext       NSDPSContext
#include "gnustep/xdps/NSDPSContextWindow.h"
#else
#include "gnustep/xgps/XGContextWindow.h"
#include "gnustep/xgps/XGContextPrivate.h"
#include "XGDrawingEngine.h"
#endif
#include "SharedX/xrtools.h"

Window _findXWindow(Display* display,
		    Window topwindow,
		    Window window_to_check,
		    int x, int y)
{
  int		newx, newy;
  Window	window;

  // find the lowest X window in the heirarchy that the global x,y
  // coordinates are in.
  if (topwindow == (Window) None) 
    {
      fprintf(stderr,"_findXWindow() error: topwindow == (Window) None \n");

      return (Window) None;
    }

  if (window_to_check == (Window) None)
    {
      fprintf(stderr,
	"_findXWindow() error: window_to_check == (Window) None \n");

      return topwindow;
    }

  // find lowest X window by iterating thru the X window's heirarchy while
  // XTranslateCoordinates returns an X Window via the window ptr

  window = window_to_check;
  while ((XTranslateCoordinates(display, topwindow, window_to_check,
	    x, y, &newx, &newy, &window) != 0)
	    && (window != (Window) None))
    {
      if (window != (Window) None)
	{
	  topwindow = window_to_check;
	  window_to_check = window;
	  x = newx;
	  y = newy;
	}
    }

  if (window == (Window) None)
    window = window_to_check;

  return window;
}


