/* 
   XGDrawingEngine.h

   Copyright (C) 1999 Free Software Foundation, Inc.

   Author:  Adam Fedor <fedor@gnu.org>
   Date: Jul 1999
   
   This file is part of the GNUstep GUI X/GPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _XGDrawingEngine_h_INCLUDE
#define _XGDrawingEngine_h_INCLUDE

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <Foundation/NSGeometry.h>
#include "gnustep/xgps/XGContext.h"
#include "SharedX/xrtools.h"

void GSWinitcontext(GSCTXT *ctxt, int window_num, GC xgc, Drawable drawable, 
		    int xoff, int yoff);

/* In XGBitmap.h */

extern int _pixmap_combine_alpha(RContext *context, RXImage *source_im, 
		     RXImage *source_alpha, RXImage *dest_im,
		     RXImage *dest_alpha, float origin_x, float origin_y,
		     NSRect drect, NSCompositingOperation op,
		     XGDrawMechanism drawMechanism);
extern int _bitmap_combine_alpha(RContext *context, 
		      const unsigned char *image_data,
		      float width, float height, int numColors,
		      BOOL usesAlpha, RXImage *dest_im, RXImage *dest_alpha,
		      NSRect drect, NSCompositingOperation op,
		      XGDrawMechanism drawMechanism);


#endif




