/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU PIPS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

/*
 * Name          : pips/src/pips_minMax.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   pipsMinMax (int ncId, int varId, long number, long height, long width,
 *               unsigned long *min, unsigned long *max)
 *
 *   int ncId           IS   The identifier returned by ncopen() or nccreate();
 *   int *varId         IS   Id of variable to query
 *   long number        IS   number of image to examine
 *   long height        IS   height of image
 *   long width         IS   width  of image
 *   unsigned long *min IS   minimum value in the image
 *   unsigned long *max IS   maximum value in the image
 * 
 * Description   : 
 *
 *   Expects long data in 'varId' and returns the minimal and maximal value.
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

int pipsMinMax (int ncId, int varId, long number, long height, long width,
                 unsigned long *min, unsigned long *max)

#else

pipsMinMax (ncId, varId, number, height, width, min, max)
    int ncId;
    int varId;
    long number;
    long height;
    long width;
    unsigned long *min;
    unsigned long *max;

#endif
{
  long edge [3];               /* Number of values to read (always 1)      */
  long start [3];              /* Coordinates of pixel                     */
  unsigned long x, y, data;    /* indizes for width and height, data       */

/*
 * Set size of data package (1 value) and init min and max
 */
  edge [0] = 1;  edge [1] = 1;  edge [2] = 1;

/*
 * Query all image data values and set *min and *max accordingly
 */
  start [0] = number;
  for (y=0; y < height; y++) {
    start [1] = y;
    for (x=0; x < width; x++) {
      start [2] = x;
      ncvarget (ncId, varId, start, edge, &data);
      *min = PipsMin (*min, data);
      *max = PipsMax (*max, data);
    } /* for (x) */
  } /* for (y) */

  return (PipsOk);
}  /* end pipsMinMax */


/* end pips_minMax.c */
