/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU PIPS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

/*
 * Name          : pips/src/pipsReadPnmValue.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   pipsReadPnmValue (file, imgType, data)
 *
 *   FILE* file       IS   Stream containing the image data
 *   int imgType      IS   One of the image types, recognized by pips
 *   void* data       IS   Pointer to sufficient memory for holding the data
 * 
 * Description   : 
 *
 *   Reads one data value from the stream 'file' and puts in *data
 *   The numbers of bytes read depend on the image type 'imgType'
 *   It returns the number of successfully read values (0 or 1).
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

int pipsReadPnmValue (FILE *file, int imgType, char *data)

#else

pipsReadPnmValue (file, imgType, data)
    FILE *file;
    int imgType;
    char *data;

#endif
{
  switch (imgType) {
    case PipsPbmAscii :
    case PipsPgmAscii :
      return (fscanf (file, " %hd", data));
    case PipsPpmAscii :
      return (fscanf (file, " %hd %hd %hd", &(data[0]), &(data[1]),
                      &(data[2])));
    case PipsPbmRaw   :
      ((char *)data)[0] = 0;    /* still unsupported */
      break;
    case PipsPgmRaw   :
      return (fread (data, 1, 1, file));
    case PipsPpmRaw   :
      return (fread (data, 3, 1, file));
  } /* end switch */

  return (PipsOk);
} /* end pipsReadPnmValue */


/* end pipsReadPnmValue.c */

