/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU PIPS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

/*
 * Name          : pips/src/pipsSelectNewJob.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   void pipsSelectNewJob (int *newJobs, int *job)
 *
 *   int *newJobs     IS   Flag that indicates wheter or not new jobs
 *                         are available
 *   int njobs        IS   The total number of jobs to process
 *   int *job         IS   Number of next new job to send
 *
 * Description   : 
 *
 *   selects the next unprocessed job, if one is available; leaves *job
 *   unchanged, if not.
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

void pipsSelectNewJob (int *newJobs, int njobs, int *job)

#else

pipsSelectNewJob (newJobs, njobs, job)
    int *newJobs;
    int njobs;
    int *job;

#endif
{
  if (*newJobs) {
    (*newJobs) = (*job < njobs-1);
    if (*newJobs)
      (*job)++;
  } /* end if */
} /* pipsSelectNewJob */


/* end pipsSelectNewJob.c */
