/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU PIPS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

/*
 * Name          : pips/src/pipsStrApp.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 * int pipsStrApp (char **s1, char *s2)
 *   char **s1        IS   a pointer to a string
 *   char *s2         IS   a string to append
 * 
 * Description   : 
 *
 *   Appends s2 to *s1, allocating memory before. s1 must not be a constant
 *   string as it is freed after construction of the concatenated string.
 *   The function returns the total length of the strings or 0 on an error
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

int pipsStrApp (char **s1, char *s2)

#else

pipsStrApp (s1, s2)
  char **s1;
  char *s2;

#endif
{
  int size = 0;               /* required size of bytes to hold both strings */
  int size1 = 0;              /* length of first string                      */
  int size2 = 0;              /* length of second string                     */
  char *s;                    /* resulting string                            */

/*
 * Add up length of strings (if defined)
 */
  if (*s1)
    size1 = strlen (*s1);
  if (s2)
    size2 = strlen (s2);
  size = size1 + size2;

/*
 * If both strings are empty or NULL, return NULL
 */
  if (size == 0)
    return (0);

/*
 * Allocate enough memory
 */
  s = (char *) calloc (size+1, sizeof (char));

/*
 * If an error ocurred, return NULL
 */
  if (!s)
    return (0);
  if (size1 > 0)
    memcpy (s, *s1, size1);
  if (size2 > 0)
    memcpy (s+size1, s2, size2+1);

/*
 * Free old string in s1
 */
  if (*s1)
    free (*s1);
  *s1 = s;

  return (size);
} /* end pipsStrApp */


/* end pipsStrApp.c */

