/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU PIPS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

/*
 * Name          : pips/src/pipsTaskManager.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   void pipsTaskManager (prgName, ntask, tid)
 *
 *   char* prgname    IS   Name of program to spawn (usually argv[0])
 *   int *ntask       IS   Number of spawned tasks
 *   int **tid        IS   Array with task id's 
 *
 * Description   : 
 *
 *   Spawns one program 'prgName' on all available hosts and returns
 *   the number and ids of all spawned tasks
 */

#include "pips.h"   /* PIPS system header file  */
#include "pvm3.h"   /* PVM system header file   */

#ifdef __STDC__

void pipsTaskManager (char *prgName, int *ntask, int **tid)

#else

pipsTaskManager (prgName, ntask, tid)
    char *prgName;
    int *ntask;
    int **tid;

#endif
{
  char *childTag[2];    /* Command line arguments for spawned children       */

/*
 * 'childTag' tells spawned tasks that they are children (passed as argv)
 */
  childTag[0] = PipsChildTag;
  childTag[1] = "\0";

/*
 * Get information on the virtual machine
 */
  pvm_config (ntask, NULL, NULL);

/*
 * Allocate memory to hold an array of tasks
 */
  *tid = (int *) calloc (*ntask, sizeof (int));

/*
 * Spawn children on all available hosts including local host
 */
  *ntask = pvm_spawn (prgName, childTag, PvmTaskDefault, "", *ntask, *tid);

/*
 * Evaluate number of successfully spawned tasks
 */
  if (*ntask == 1)
    fprintf (stderr, "Could only spawn one task - will run very slowly !\n");
  if (*ntask < 1) {
    fprintf (stderr, "Error %d occured when I tried to spawn children\n", *ntask);
    pvm_exit ();
    return;
  } /* end if */

} /* end pipsTaskManager */


/* end pipsTaskManager.c */
