"======================================================================
|
|   BlockContext Method Definitions
|
|   $Revision: 1.8.5$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


ContextPart variableSubclass: #BlockContext
       instanceVariableNames: 'outerContext '
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Language-Implementation'
!

BlockContext comment: 
'My instances represent executing Smalltalk blocks, which are portions of
executeable code that have access to the environment that they were declared
in, take parameters, and result from BlockClosure objects created to be
executed by methods outside the current class.  Block contexts are
created by messages sent to compute a closure''s value.  They contain a stack
and also provide some methods that can be used in inspection or debugging.' !



!BlockContext methodsFor: 'printing'!

printOn: aStream
    "Print a representation for the receiver on aStream"
    self method printOn: aStream
! !


!BlockContext methodsFor: 'accessing'!

caller
    "Answer the context that called the receiver"
    ^self parentContext
!

isEnvironment
    "To create a valid execution environment for the interpreter even before
     it starts, GST creates a fake context whose selector is nil and which
     can be used as a marker for the current execution environment.  Answer
     whether the receiver is that kind of context (always false, since
     those contexts are always MethodContexts)."
    ^false
!

outerContext
    "Answer the outer block/method context for the receiver"
    ^outerContext
!

nthOuterContext: n
    "Answer the n-th outer block/method context for the receiver"
    | ctx |
    ctx := self.
    n timesRepeat: [ ctx := ctx outerContext ].
    ^ctx
!

isBlock
    "Answer whether the receiver is a block context"
    ^true
!

home
    "Answer the MethodContext to which the receiver refers, or
     nil if it has been optimized away"
    ^outerContext isNil
	ifTrue: [ nil ]
	ifFalse: [ outerContext home ]
! !


!BlockContext methodsFor: 'private'!

initBlock: aBlockClosure
    "Private - Make a real block context from the given BlockClosure."

    parent := nil.
    ip := 0.
    sp := 0.
    receiver := aBlockClosure receiver.
    method := aBlockClosure block.
    outerContext := aBlockClosure outerContext.
! !
