"======================================================================
|
|   DirectedMessage Method Definitions
|
|   $Revision: 1.8.5$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"



Message subclass: #DirectedMessage
    instanceVariableNames: 'receiver '
    classVariableNames: ''
    poolDictionaries: ''
    category: 'Language-Implementation'!

DirectedMessage comment: 
'I represent a message send: I contain the receiver, selector and arguments
for a message.'!
	   

!DirectedMessage methodsFor: 'basic'!

printOn: aStream
    "Print a representation of the receiver on aStream"

    aStream
	print: receiver;
	nextPutAll: ': '.

    super printOn: aStream
!

send
    "Send the message"
    ^self sendTo: receiver
! !


!DirectedMessage methodsFor: 'accessing'!

receiver: anObject
    "Change the receiver"
    receiver := anObject
!

receiver
    "Answer the receiver"
    ^receiver
! !


!DirectedMessage class methodsFor: 'creating instances'!

selector: aSymbol arguments: anArray 
    self shouldNotImplement
!

selector: aSymbol arguments: anArray receiver: anObject
    "Create a new instance of the receiver"

    ^(super selector: aSymbol arguments: anArray)
	receiver: anObject
! !

