/******************************** -*- C -*- ****************************
 *
 *	xmalloc, xrealloc and xfree for Smalltalk
 *
 *	$Revision: 1.8.5$
 *	$Date: 2000/12/27 10:45:49$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 * Written by Steve Byrne.
 *
 * This file is part of GNU Smalltalk.
 *
 * GNU Smalltalk is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later 
 * version.
 * 
 * GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 ***********************************************************************/

#include "gstconf.h"
#include "alloc.h"

#include <stdio.h>

#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#else
#include <malloc.h>
#endif /* STDC_HEADERS */


char *
xmalloc (n)
     register size_t n;
{
  register char *block;

  block = (char*)malloc(n);
  if (!block && n) {
    nomemory(1);
  }

  return (block);
}

char *
xcalloc (n, s)
     register size_t n;
     register size_t s;
{
  register char *block;

  block = (char*)calloc(n, s);
  if (!block && n && s) {
    nomemory(1);
  }

  return (block);
}

char *
xrealloc (p, n)
     register char *p;
     register size_t n;
{
  register char *block;

  /* We must call malloc explicitly when BLOCK is 0, since some
     reallocs don't do this.  */
  if (!p) {
    block = (char*) malloc (n);
    if (!block && n) {
      nomemory(1);
    }
  } else {
    if (n) {
      block = (char*) realloc(p, n);
    } else {
      free (p);
      block = NULL;
    }
  }

  /* !!! check to see if realloc frees existing memory if it cannot
   *  allocate more -- hmmm, ANSI says it shouldn't */ 
  return (block);
}

void
xfree (p)
     register char *p;
{
  free(p);
}

void
nomemory (fatal)
     int fatal;
{
  fprintf(stderr, "\n\n[Memory allocation failure]"
	"\nCan't allocate enough memory to continue.\n");

  if (fatal)
    exit (1);
}


