"======================================================================
|
|   Smalltalk TCP/IP sockets - Datagram class
|
|   $Revision: 1.8.5$
|   $Date: 2000/12/27 10:45:49$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #Datagram
	  instanceVariableNames: 'data address port'
	  classVariableNames: ''
	  poolDictionaries: ''
	  category: 'Sockets-Protocols'
!


!Datagram class methodsFor: 'instance creation'!

data: aByteArray address: ipAddress port: port
    ^self new setData: aByteArray address: ipAddress port: port
!

object: object address: ipAddress port: port
    | stream |
    stream := ByteStream on: (ByteArray new: 100).
    ^self
	data: (ObjectDumper dump: object to: stream)
	address: ipAddress
	port: port
! !

!Datagram methodsFor: 'accessing'!

address
    ^address
!

address: ipAddress
    address := ipAddress
!

data
    ^data
!

data: aByteArray
    data := aByteArray
!

get
    ^ObjectDumper loadFrom: (ByteStream on: self data)
!

port
    ^port
!

port: thePort
    port := thePort
! !

!Datagram methodsFor: 'private'!

setData: aByteArray address: ipAddress port: thePort
    data := aByteArray.
    address := ipAddress.
    port := thePort
!

sockAddr
    ^address port: port
! !
