@c  Copyright (C) 2000, 2001, 2002  Tom Cato Amundsen
@c  Permission is granted to copy, distribute and/or modify this document
@c  under the terms of the GNU Free Documentation License, Version 1.1
@c  or any later version published by the Free Software Foundation;
@c  with no Invariant Sections.

@c  $Id: lessonfiles.texi.m4,v 1.8.2.4 2002/02/17 22:42:35 tom Exp $

m4_include(texidefinitions.m4)

@settitle Lesson files
@section  Lesson files

If you want to write lesson files, my advise is to look at
some of the files in @file{lesson-files/} and use this
document and the @uref{music-format.html, music format}
spec for reference.

@subsection Lesson file contents
A lesson file contains of a header block and one or more
question blocks:
@example
header @{
  ASSIGNMENT
  ASSIGNMENT
  ...
@}
question @{
  ASSIGNMENT
  ...
@}
@end example

@subsection Header block

The header block can be placed anywhere in the file, but by convention
it should be the first block in the file. If more that one header block
is found, for example when using the @code{include} command, only the
first header block is used, the rest are ignored.

Definitions to put in the header block:

@table @code

@item version = STRING
Tell the oldest version of solfege the lessonfile is known to
work with. For example @code{version = "1.1.1"}

This variable is not required, but it should be used because
it can (but don't guarantee to) help avoid
trouble if the lesson file format changes in the future.

@item title = STRING
Short oneline description.

@item description = STRING
Long description that can contain html tags.

@item content = LIST
Possible values:  @code{chord}, @code{dictation}, @code{id-by-name},
@code{harmony} and @code{sing-chord}

Some lessonfiles can be useful for more than one exercise.
For example a file with chords can also be used by the id-by-name
exercise, and should have: @code{content = chord, id-by-name}

@item musicformat = FORMAT
     @code{normal} : The default value

     @code{chord} : any music "MUSIC CODE" will be interpreted as:
     @example
          \staff@{ < MUSIC CODE > @}
     @end example
        or
     @example
          \staff\transpose NOTENAME@{ < MUSIC CODE > @}
     @end example
     
     @code{musicformat = chord} is necessary if lesson files
        written for the chord exercise should be used by for example the
        id-by-name exercise.
        
     @code{satb} : the music @code{"c | bes g | e | G C"}
       will be interpreted as:
       @example
       \staff@{ \stemUp < c > @}
       \addvoice@{ \stemDown < bes g > @}
       \staff@{\clef bass; \stemUp < e > @}
       \addvoice@{ \stemDown < G C > @}
       @end example
       This is used by the @uref{solfege:practise/sing-chord,
       sing-chord} exercise.
 @item random_transpose = yes | no
 @item random_transpose = integer, integer
 (Default: no) In some exercises the program can transpose the
     music to create variation. The variable is ignored in exercises
     that does not support transposing.

     If you use the format with two integers, the integers tell the
     range the music should be translated. If you write
     @code{random_transpose = -5, 12} the music will be ransposed
     no more than 5 semitones down or 12 semitones up (one octave).

     @code{random_transpose = yes} is the same as 
     @code{random_transpose = -5, 6} and @code{random_transpose = no}
     is the same as @code{random_transpose = 0, 0}
     
 @item labelformat = normal | progression
 (Default: normal)

@end table

@subsubsection For "Id by name" exercise only
@table @code
@item filldir = horiz | vertic
@item fillnum = INTEGER
    These two variables control how the buttons are layed out.
    @code{filldir} tell the direction the buttons are filled,
    and @code{fillnum} tell how many buttons there are in
    each row or column.
@end table

@subsection Question block
@table @code
@item name = "some short name"
Questions written for @emph{id-by-name} and @emph{chord} exercise
need a name.

@item music = "\staff@{c'2 g' e4 e c1@}"
The music in the question. Note that there is a shortcut. Instead of:
@example
   question @{
   tempo = 160/4
   name = "Lisa gikk til skolen"
   music = "\staff\relative c'@{c d e f g2 g2@}"  
@}
@end example

you can write:

@example
question @{
   tempo = 160/4
   name = "Lisa gikk til skolen"
   "\staff\relative c'@{c d e f g2 g2@}"  
@}
@end example

@item tempo = 130/4
beats per minute / notelen per beat
@end table

@subsubsection Chord questions only
In lesson files that is written to work with @code{chord} exercise,
two more variables can used:

@table @code
@item inversion
0 = root position, 1 = first inversion etc.

@item toptone
1, 3, 5, 7
@end table


@subsubsection Dictation exercise
By default, the dictation exercise will show the first column of
   music, and then the user should write the rest. But if the first
   column is not good enough, if there for example are only rests on
   the first beat, these two variables can tell the program how much
   music to display:
@table @code
@item clue_end = nn/dd
@code{clue_end=1/4} will display all music in the first quarter note.

@item clue_music = MUSIC
Write the exact music you want to display. If for example you
want to display the whoe bar in the upper staff, and only one 
note in the lower staff.
@end table
(Use only one if these variables in a question. Using both are undefined.)

@subsubsection Sing chord exercise
Questions for this exercise need to have the @code{key}
variable set if the key signature is anything else than
@emph{c} major (or @emph{a} minor). Example:
@example
question @{ "c''|e'|g|c" @}
question @{ "a'|e'|c'|a" @}
question @{ key="d \major" "a'|fis'|d'|d"@}
question @{ key="f \minor" "as'|f'|c'|f"@}
@end example

@subsection Global variables
Global variables can save you a few key strokes.

@example
s = "\score\relative c'@{ %s @}

question @{
  # instead of music = "\score\relative c'@{ c d e f g2 g2 @} :
  music = s % "c d e f g2 g"
@}
@end example 

The global variable @code{tempo} will be the default tempo
for the questions following the definition. If not set, the
default value is 120 beats per minute. That equals the definition

@code{tempo = 60/4}


@subsection Comments
Everything after # on a line is ignored


@subsection Grammar

Disclaimer: I don't know any of the standard ways of 
describing grammar, like BNF. So this is just an attemt to describe 
the file format to get people started writing lesson files.

Lessonfiles consists of assignment statements and blocks
containing assignment statements.

@subsubsection Functions
@table @code
@item _
takes a string as its only argument. Use this if you
want Solfege to translate the string for you. Example:

@code{description = _("This is a short description")}

@item include
includes another file in to this file. Example:

@code{include(singchord-1)}
@end table

@subsubsection Types
@table @code
@item string
is quoted using the @code{"} character, like this: @code{"this is a string"}.
The string can contain line breaks, so this is valid:
@example
description = "<h1>Long desription</h1>
               This lessonfile need very much descriptions.
               bla bla bla"
@end example

If the string need to contain the @code{"} character, you have
to use tripple quotes:
@example
description = """Try <a href="solfege:practise/melodic-intervall">this
</a> for a simpler interval exercise."""
@end example

@item integer
is an integer is an integer...

@item tempotype (in lack of a better name)
is entered as @code{bpm/beatlen}. An example:

@code{tempo = 120/4}

will set the tempo to 120 beats per minute, each beat being a quarter note.
@end table

@subsection Operators
The operators can only be used on strings
@table @code
@item +
is used for joining strings
@item %
is similar to what you find in python, but it is very limited. It
only know about @code{%s}. Examples:
@example
"\staff\relative c'@{%s@}" % "c d e"
@end example
 evaluates to
@example
"\staff\relative c'@{c d e@}"
@end example
@end table

@subsection Reserved words
To be put on the right side of assignments. The current parser does
not complain if you redefines the identifiers, so @emph{don't do that!}

@table @code
@item chord, dictation, id-by-name, sing-chord
Possible values for @code{content}

@item horiz, vertic
Table filling in id-by-name exercise

@item normal, progression
@code{labelformat} values.

@item yes, no

@end table

@subsection Identifiers
Identifiers match the regular expression "[a-zA-Z]+[\w_-]*".

@subsection Block
There are two block types, @code{header} and @code{question}
@example
blocktype @{
  CONTENTS
@}
@end example
