/* Source Installer, Copyright (c) 2005 Claudio Fontana

   srcalloc.h - simple wrappers for heap allocation functions

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#ifndef SRCINST_ALLOC_H
#define SRCINST_ALLOC_H

/* these functions are simple wrappers around malloc, realloc, strdup.
   You not need to check the return value for (void*)0 */
   
void* srcinst_malloc(size_t s);
void* srcinst_realloc(void* p, size_t s);
char* srcinst_strdup(char* s);

/* return heap-alloc-ed joined string. Remember a 0 as the last arg. */
char* srcinst_strjoin(char* args, ...);

/* just puts a slash in between and return the newly allocated string. */
char* srcinst_fnjoin(char* str1, char* str2);

/* append to the heap allocated P string the contents of S string.
   P is reallocated to make room for S contents, so you generally want to
   say:

   my_big_string = srcinst_append(my_big_string, "something else");
*/

char* srcinst_append(char* p, char* s);	      /* append to a HEAP string     */

#endif /* SRCINST_ALLOC_H */

