/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

   srcerror.c - custom error handling

   This program is free software; you can redistribute it and/or modify
       it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
       (at your option) any later version.

   This program is distributed in the hope that it will be useful,
       but WITHOUT ANY WARRANTY; without even the implied warranty of
       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
       GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
       along with this program (look for the file called COPYING);
       if not, write to the Free Software Foundation, Inc.,
           51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

       You can contact the author (Claudio Fontana) by sending a mail
       to claudio@gnu.org
*/

#include "src_stdinc.h"

static const char *_error_strings[] = {
    "",				/* SRCINST_ERR_OK      */
    N_("core error"),		/* SRCINST_ERR_CORE    */
    N_("heap error"),		/* SRCINST_ERR_HEAP    */
    N_("regular expression error"), /* SRCINST_ERR_REGEX   */
    N_("user lock-file error"),	/* SRCINST_ERR_LOCK    */
    N_("action error"),		/* SRCINST_ERR_ACTION  */
    N_("parser error"),		/* SRCINST_ERR_PARSER  */
    N_("permission denied"),	/* SRCINST_ERR_PERM    */
    N_("invalid"),		/* SRCINST_ERR_INVALID */
    N_("missing"),		/* SRCINST_ERR_MISSING */
    N_("policy error"),		/* SRCINST_ERR_POLICY  */
    N_("interrupted"),		/* SRCINST_ERR_INTR    */
    N_("resource already exists"), /* SRCINST_ERR_BUSY    */
    0
};

void srcinst_error(int errcode, const char *s, char *t)
{
    if (errcode > 0 && errcode < SRCINST_ERR_N) {
	fprintf(stderr, "srcinst: <%s> %s", _(_error_strings[errcode]), s);

	if (t) {
	    fprintf(stderr, ": %s", t);
	}

	fprintf(stderr, ".\n");
    }

    srcinst_exit(errcode);
}

void srcinst_warning(int errcode, const char *s, char *t)
{
    if (errcode > 0 && errcode < SRCINST_ERR_N) {
	fprintf(stderr, "srcinst: <%s> %s", _(_error_strings[errcode]), s);

	if (t) {
	    fprintf(stderr, ": %s", t);
	}

	fprintf(stderr, ".\n");
    }
}

char *srcinst_error_string(int errcode)
{
    if (errcode > 0 && errcode < SRCINST_ERR_N) {
	return (char *)_(_error_strings[errcode]);
    }
    return 0;
}
