/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 options.h - sourceinstall command line options

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef OPTIONS_H
#define OPTIONS_H

struct option_data {
  char short_option; char* long_option;
  char* params[5]; char* values[5];
  
  /* 0: not yet chosen, 1: already, chosen, 2: multiple choice!
     the case 2 is special, in that values[0] becomes a pointer to a
     srcinst_string_list that contains the values */
  char chosen;
 
  char* help;  
};

struct options {
  char* package;		/* the package name on which to act */

  char install;			/* whether to install during add */
  char source;		        /* whether to keep source */
  char strip;			/* install-strip? */
  char force;			/* NOP and NIY */
  char quiet;			/* suppress non-error, non-requested msgs */
  char src_compress;		/* source compression format to use */

  /* params to pass to ./configure script */
  struct srcinst_string_list configure_strings;

  char* subdir;			/* build subdirectory from the top_srcdir */
  char* prefix;			/* passed to configure as last param */
  char* user, *pass;		/* login information */
};

void init_options(struct options* o);

extern struct option_data action_list[];
extern struct option_data option_list[];

#endif /* OPTIONS_H */
