/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 options.c - sourceinstall command line options

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "src_stdinc.h"
#include "options.h"

struct option_data action_list[] = {
    {'h', "help", {0}, {0}, 0, N_(". show brief command line help") },
    {'V', "version", {0}, {0}, 0, N_(". show program version") },
    {'l', "list", {0}, {0}, 0, 
     N_(". list all existing packages; if PACKAGE_NAME is specified, it is "
	" treated as a regular expression string, and only matching package "
	" names are listed") },
    {'a', "add", {N_("FILENAME"), 0}, {0, 0}, 0,
     N_(". add new source package from FILENAME; the package name will be "
	"taken from the top source directory by default, or from PACKAGE_NAME "
	"if specified") },
    {'r', "remove", {0}, {0}, 0, 
     N_(". remove package PACKAGE_NAME completely") },
    {'c', "check", {0}, {0}, 0,
     N_(". show and validate package PACKAGE_NAME information") },
    {'g', "upgrade", {N_("OLD_PACK"), N_("FILENAME"), 0}, {0, 0, 0}, 0,
     N_(". replace OLD_PACK with a new version built from FILENAME. "
	"The new package name will be taken from the top source directory "
	"by default, or from PACKAGE_NAME if specified") },
    {'i', "install", {0}, {0}, 0,
     N_(". install known package PACKAGE_NAME from stored source code") },
    {'u', "uninstall", {0}, {0}, 0, N_(". uninstall package PACKAGE_NAME, but "
				       "do not delete source if available") },
    {'d', "description", {N_("STRING"), 0}, {0, 0}, 0,
     N_(". associate first line of STRING to PACKAGE_NAME short description, "
	"and the remaining lines to the long description. If STRING is empty,"
	"remove descriptions from the package. Use your shell quotation "
	"characters to submit a STRING containing newlines") },
    {'n', "rename", {N_("NEW_NAME"), 0}, {0, 0}, 0,
     N_(". rename existing package PACKAGE_NAME to NEW_NAME") },
    {'X', "export-xml", {N_("FILENAME"), 0}, {0, 0}, 0,
     N_(". export package PACKAGE_NAME information (or all packages if not "
	"specified) in XML format to FILENAME (use - for stdout)") },
    {'T', "export-text", {N_("FILENAME"), 0}, {0, 0}, 0,
     N_(". export package PACKAGE_NAME information (or all packages if not "
	"specified) in text format to FILENAME (use - for stdout)") },
    {'L', "export-list", {N_("FILENAME"), 0}, {0, 0}, 0,
     N_(". export package PACKAGE_NAME installed files list to FILENAME "
	"(use - for stdout)") },
    {'k', "pack", {N_("FILENAME"), 0}, {0, 0}, 0,
     N_(". build binary tarball from the installed package PACKAGE_NAME, "
	"and save it as FILENAME") },
    {'1', "detect-build", {N_("FILENAME"), 0}, {0, 0}, 0,
     N_(". scan FILENAME, reporting configure scripts in all subdirectories, "
	"and which autoconf version generated them. This can be useful to "
	"choose a build subdir, and to run on a new, unknown package to decide"
	" whether to install it") },
    {'2', "detect-feats", {N_("FILENAME"), 0}, {0, 0}, 0,
     N_(". scan FILENAME, reporting and testing the configure script that "
	"will be used (if present), and get the features supported by the "
	"generated Makefile. This detection action is useful to run after "
	"'-1', coupled with '-D' to choose a particular build subdirectory "
	"(and thus configure script/Makefile)") },
    {'3', "detect-opts", {N_("FILENAME"), 0}, {0, 0}, 0,
     N_(". scan FILENAME for configure options") },
    {0, 0, {0}, {0}, 0, 0}
};

struct option_data option_list[] = {
    {'S', "no-source", {0}, {0}, 0,
     N_(". do not keep source code during installation") },
    {'t', "strip", {0}, {0}, 0,
     N_(". strip binaries during installation (not recommended)") },
    {'z', "compression", {N_("FORMAT"), 0}, {0, 0}, 0,
     N_(". use FORMAT as compression. Can assume values gz, bz2, Z") },
    {'C', "configure", {N_("STRING"), 0}, {0, 0}, 2,
     N_(". (multiple option) force (re)configure of the package, and add "
	"STRING to the configure flags; do not use for specifying "
	"installation prefix, or it will be ignored: "
	"see --prefix below for that.") },
    {'D', "subdir", {N_("STRING"), 0}, {0, 0}, 0,
     N_(". use STRING as build subdirectory for the package") },
    {'p', "prefix", {N_("STRING"), 0}, {0, 0}, 0,
     N_(". specify installation prefix for the package. "
	"For other configure-time options see --configure above") },
    {'f', "force", {0}, {0}, 0,
     N_(". force execution of the action even when not recommended") },
    {'U', "user", {N_("STRING"), 0}, {0, 0}, 0,
     N_(". privileged user login to revert to if required [NIY]") },
    {'P', "pass", {N_("STRING"), 0}, {0, 0}, 0,
     N_(". privileged user password to revert to if required [NIY]") },
    {'q', "quiet", {0}, {0}, 0,
     N_(". suppress verbose info on standard output") },
    {'Q', "verbose", {0}, {0}, 0,
     N_(". send verbose info to standard output") },
    {0, 0, {0}, {0}, 0, 0}
};

void init_options(struct options *o)
{
    o->package = 0;
    o->source = srcinst_get_pref_keep_source();
    o->strip = srcinst_get_pref_strip();
    o->install = srcinst_get_pref_install();
    o->force = 0;
    o->quiet = srcinst_get_pref_quiet();
    o->src_compress = srcinst_get_pref_src_compress();
    srcinst_init_string_list(&(o->configure_strings));
    srcinst_add_string_list(&o->configure_strings, "./configure");
    option_list[3].values[0] = (char *) (&(o->configure_strings));
    o->subdir = 0;
    o->prefix = srcinst_get_pref_prefix();
    o->user = o->pass = 0;
}
