/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 sourceinstall.h - sourceinstall command line frontend protoss and macros

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef SOURCEINSTALL_H
#define SOURCEINSTALL_H

int add_package(char *packagename, char *source);
int check_package(char *packagename);
int list_packages(char *pattern);
int install_package_aux(SRCINST_PHANDLE h, char *source, int configureq);
int install_package(char *packagename);
int uninstall_package(char *packagename);
int upgrade_package(char *packagename, char *oldname, char *source);
int remove_package(char *packagename);
int export_info(char *packname, char *export_format, char *filename);
int export_binary(char *filename, char *package_name);
int parse_cmdline(int argc, char *argv[]);
void cmdline_help_usage(void);
void cmdline_help(void);
void cmdline_help_options(struct option_data *o);
void cmdline_version(void);
int cmdline_options_apply(int selected_action);
int describe_package(char *packagename, char *string);
int rename_package(char *packagename, char *newname);
int detect_builddirs(char *packagename, char *source);
int detect_feats(char *packagename, char *source);
void print_option_set(struct srcinst_configure_options *set);

#endif				/* SOURCEINSTALL_H */
