/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 events.c - Event bindings

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "gui.h"
#include "menu.h"
#include "package_list.h"
#include "toolbar.h"
#include "edit.h"
#include "pref.h"
#include "events.h"

/* note that not all event bindings are set here.
   Widgets built dynamically are connected when created.
   Search the source for g_signal_connect */

void events_bind(void) {
  printf("events_bind\n");

  /* main */

  g_signal_connect(G_OBJECT(w_main[W_MAIN]), "delete-event",
		   G_CALLBACK(gui_delete_event), NULL);
  
  g_signal_connect(G_OBJECT(w_main[W_MAIN]), "destroy",
		   G_CALLBACK(gui_destroy), NULL);

  /* package_list */

  g_signal_connect(G_OBJECT(w_package_list[W_PACKAGE_LIST]), "cursor-changed", G_CALLBACK(package_list_cursor_changed), NULL);

  g_signal_connect(G_OBJECT(w_package_list[W_PACKAGE_LIST]), "row-activated", G_CALLBACK(package_list_row_activated), NULL);

  g_signal_connect(G_OBJECT(w_package_list[W_PACKAGE_LIST]), "popup-menu",
		   G_CALLBACK(package_list_popup_menu), NULL);

  g_signal_connect(G_OBJECT(w_package_list[W_PACKAGE_LIST]), "button-press-event", G_CALLBACK(package_list_button_press_event), NULL);

  /* package information edit */

  g_signal_connect(G_OBJECT(w_edit[W_EDIT_APPLY]), "clicked",
		   G_CALLBACK(edit_apply), NULL);

  g_signal_connect(G_OBJECT(w_edit[W_EDIT_CANCEL]), "clicked",
		   G_CALLBACK(edit_cancel), NULL);

  /* pref */

  g_signal_connect(G_OBJECT(w_pref[W_PREF]), "delete-event",
		   G_CALLBACK(pref_delete_event), NULL);

  g_signal_connect(G_OBJECT(w_pref[W_PREF_PREFIX_BROWSE]), "clicked",
		   G_CALLBACK(pref_directory_browse_clicked), 
		   w_pref[W_PREF_PREFIX]);

  g_signal_connect(G_OBJECT(w_pref[W_PREF_ADD_BROWSE]), "clicked",
		   G_CALLBACK(pref_directory_browse_clicked), 
		   w_pref[W_PREF_ADD]);

  g_signal_connect(G_OBJECT(w_pref[W_PREF_SAVE]), "clicked",
		   G_CALLBACK(pref_save_clicked), NULL);
  
  g_signal_connect(G_OBJECT(w_pref[W_PREF_APPLY]), "clicked",
		   G_CALLBACK(pref_apply_clicked), NULL);

  g_signal_connect(G_OBJECT(w_pref[W_PREF_CANCEL]), "clicked",
		   G_CALLBACK(pref_cancel_clicked), NULL);


  /* toolbar and menu actions */

  g_signal_connect(G_OBJECT(w_toolbar[W_TOOLBAR_STOP]), "clicked",
		   G_CALLBACK(gui_action_stop), NULL);

  g_signal_connect(G_OBJECT(w_toolbar[W_TOOLBAR_ADD]), "clicked",
		   G_CALLBACK(gui_action_add), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_PACKAGE_ADD]), "activate",
		   G_CALLBACK(gui_action_add), NULL);

  g_signal_connect(G_OBJECT(w_toolbar[W_TOOLBAR_REMOVE]), "clicked",
		   G_CALLBACK(gui_action_remove), NULL);
  
  g_signal_connect(G_OBJECT(w_menu[W_MENU_PACKAGE_REMOVE]), "activate",
		   G_CALLBACK(gui_action_remove), NULL);
  
  g_signal_connect(G_OBJECT(w_toolbar[W_TOOLBAR_INSTALL]), "clicked",
		   G_CALLBACK(gui_action_install), NULL);
  
  g_signal_connect(G_OBJECT(w_menu[W_MENU_PACKAGE_INSTALL]), "activate",
		   G_CALLBACK(gui_action_install), NULL);

  g_signal_connect(G_OBJECT(w_toolbar[W_TOOLBAR_UNINSTALL]), "clicked",
		   G_CALLBACK(gui_action_uninstall), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_PACKAGE_UNINSTALL]), "activate",
		   G_CALLBACK(gui_action_uninstall), NULL);

  g_signal_connect(G_OBJECT(w_toolbar[W_TOOLBAR_UPGRADE]), "clicked",
		   G_CALLBACK(gui_action_upgrade), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_PACKAGE_UPGRADE]), "activate",
		   G_CALLBACK(gui_action_upgrade), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_EDIT_PREF]), "activate",
		   G_CALLBACK(gui_action_pref), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_WINDOW_DEFAULT]), "activate",
		   G_CALLBACK(gui_action_default_size), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_HELP_ABOUT]), "activate",
		   G_CALLBACK(gui_action_about), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_FILE_QUIT]), "activate",
		   G_CALLBACK(gui_delete_event), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_PACKAGE_EXPORT_ALL]), "activate",
		   G_CALLBACK(gui_action_export_all), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_PACKAGE_EXPORT_INFO]), "activate",
		   G_CALLBACK(gui_action_export_info), NULL);

  g_signal_connect(G_OBJECT(w_menu[W_MENU_PACKAGE_EXPORT_BIN]), "activate",
		   G_CALLBACK(gui_action_export_bin), NULL);
}

void events_unbind(void) {
  printf("events_unbind\n");

  /* unbind some dangerous events prior to quitting. */

  /*
  g_signal_handlers_disconnect_by_func(G_OBJECT(w_main[W_MAIN]), 
				       G_CALLBACK(gui_delete_event), NULL);

  g_signal_handlers_disconnect_by_func(G_OBJECT(w_main[W_MAIN]), 
				       G_CALLBACK(gui_destroy), NULL);

  */
}

