/* Source Installer, Copyright (c) 2005-2006 Claudio Fontana

 options.c - sourceinstall options

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"
#include "options.h"

void options_init(struct options* o) {
  printf("options_init\n");
  o->install = srcinst_get_pref_install();
  o->source = srcinst_get_pref_keep_source();
  o->strip = srcinst_get_pref_strip();
  o->quiet = srcinst_get_pref_quiet();
  o->src_compress = srcinst_get_pref_src_compress();
  o->manual_conf = srcinst_get_pref_manual_conf();

  if ((o->prefix = srcinst_get_pref_prefix())) {
    o->prefix = srcinst_strdup(o->prefix);
  }
  
  if ((o->add_directory = srcinst_get_pref_add_directory())) {
    o->add_directory = srcinst_strdup(o->add_directory);
  }
}
