/* Source Installer, Copyright (c) 2005 Claudio Fontana

 sourceinstall-gtk.c - sourceinstall GTK frontend

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#include "global.h"

#include "gui.h"
#include "menu.h"
#include "events.h"
#include "package_list.h"
#include "greeting.h"
#include "dialog.h"
#include "action.h"

#include "sourceinstall-gtk.h"

void state_init(void) {
  state.actions_locked = 0;
  state.package = 0;
  options_init(&state.o);
}

char* program_name;

static void usage(void) {
  printf("GNU Source Installer GTK version " PACKAGE_VERSION " usage:\n\n");
  printf("%s [ACTION | FILENAME]\n\n", program_name);
  
  printf("ACTIONS\n");
  printf("-h, --help                 . show brief command line help\n");
  printf("-V, --version              . show program version string\n");
  printf("FILENAME\n");
  printf("If none of the previous actions is specified, and a filename\n"
	 "is given instead, run a package add action on FILENAME,\n"
	 "assign default package name.\n\n");
	 
  printf("Run program without any arguments to start the GUI normally.\n");
  printf("Send bug reports to " PACKAGE_BUGREPORT " .\n");
}

static void version(void) {
  printf("GNU Source Installer GTK version " PACKAGE_VERSION "\n"
	 "Copyright (c) 2005-2006 Claudio Fontana\n"
	 "This is Free Software that comes with NO WARRANTY;\n"
	 "(see file COPYING for more details)\n");
}

int main(int argc, char* argv[]) {
  char* title = "main"; int i;
  char* filename = 0;

  program_name = (argv[0] ? srcinst_basename(argv[0]) : "sourceinstall-gtk");

  for (i = 1; i < argc; i++) {
    if (strcmp(argv[i], "-h") == 0 || strcmp(argv[i], "--help") == 0) {
      usage();
      return 0;

    } else if (strcmp(argv[i], "-V") == 0 ||
	       strcmp(argv[i], "--version") == 0) {
      version();
      return 0;

    } else {
      if (filename) {
	usage();
	return 1;
      }
      filename = argv[i];
    }
  }

  gtk_init(&argc, &argv);
  gui_splash();

  if (!srcinst_init(SRCINST_FLAG_DEFAULT)) {
    dialog_error(title, "libsrcinst error", "could not initialize libsrcinst", 0);
  }
  atexit(srcinst_fini);

  state_init();

  gui_unsplash(); gui_init();
  events_bind();
  package_list_fill();
  gui_show();
  greeting_show();
  
  if (filename)
    action_add(filename, 0);

  gtk_main();
  return 0;
}

