/*
 *   Copyright (C) 1997, 1998, 1999, 2000 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _sqlutil_h
#define _sqlutil_h

#include <mysql.h>
#include <mysqld_error.h>

#define WEBBASE_INTEGER_VALUE_SIZE 32

/*
 * Secure version of the corresponding mysql call
 */
int smysql_query(MYSQL* mysql, const char* query);
void smysql_queries(MYSQL* mysql, const char** queries, int queries_length);
MYSQL_RES* smysql_store_result(MYSQL* mysql);

/*
 * Utilities
 */
char* sql_quote_char_simple(char* from, int from_size);
char* sql_quote_char(char** to, int* to_size, char* from, int from_size);
time_t sql_date2time(char* date);
char* sql_itoa(int value);
typedef void (*sql_select_callback)(char* arg, MYSQL_RES* res, MYSQL_ROW row);
int sql_select(MYSQL* mysql, char* header, char* query, sql_select_callback callback, char* callback_arg);
int sql_select_value(MYSQL* mysql, char* query, char* value, int value_size);
int sql_select_exists(MYSQL* mysql, char* query);
void sqlutil_verbose(int level);

#endif /* _sqlutil_h */

