/*
 *   Copyright (C) 1997, 1998, 1999, 2000 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _webbase_hooks_h
#define _webbase_hooks_h

#include <webbase.h>

#define HOOK_MAX_RECORDS 200000000 

typedef struct webbase_hook_params webbase_hook_params_t;

typedef int (*webbase_hook_init)(webbase_hook_params_t* params, webbase_t* base);
typedef int (*webbase_hook_ok)(webbase_hook_params_t* params, webbase_url_t* webbase_url);
typedef int (*webbase_hook_insert)(webbase_hook_params_t* params, webbase_url_t* webbase_url);
typedef int (*webbase_hook_insert_watch)(webbase_hook_params_t* params);
typedef int (*webbase_hook_update)(webbase_hook_params_t* params, webbase_url_t* webbase_url);
typedef int (*webbase_hook_prepare)(webbase_hook_params_t* params, int id, char* url, int url_length);
typedef int (*webbase_hook_delete_id)(webbase_hook_params_t* params, int id, char* url, int url_length);
typedef int (*webbase_hook_rehook_start)(webbase_hook_params_t* params);
typedef int (*webbase_hook_rehook_end)(webbase_hook_params_t* params);
typedef int (*webbase_hook_rebuild_init)(webbase_hook_params_t* params, const char* where);
typedef int (*webbase_hook_rebuild_start)(webbase_hook_params_t* params);
typedef int (*webbase_hook_rebuild_end)(webbase_hook_params_t* params);
typedef int (*webbase_hook_info_set)(webbase_hook_params_t* params, const char* info);
typedef int (*webbase_hook_server)(webbase_hook_params_t* params, int server);
typedef char* (*webbase_hook_url2server)(webbase_hook_params_t* params, const char* url);
typedef int (*webbase_hook_end)(webbase_hook_params_t* params);
typedef int (*webbase_hook_getopt)(webbase_hook_params_t* params, int argc, char** argv);

typedef struct webbase_hook_params {
  webbase_hook_init init;
  webbase_hook_ok ok;
  webbase_hook_insert insert;
  webbase_hook_insert_watch insert_watch;
  webbase_hook_update update;
  webbase_hook_prepare prepare;
  webbase_hook_delete_id delete_id;
  webbase_hook_rehook_start rehook_start;
  webbase_hook_rehook_end rehook_end;
  webbase_hook_rebuild_init rebuild_init;
  webbase_hook_rebuild_start rebuild_start;
  webbase_hook_rebuild_end rebuild_end;
  webbase_hook_info_set info_set;
  webbase_hook_server server;
  webbase_hook_url2server url2server;
  webbase_hook_end tend;
  webbase_hook_getopt getopt;

  webbase_t* base;	/* Access to the webbase database. */
  int server_id;	

  int verbose;		/* Verbosity level. */
  char* name;		/* Name of the hook library. */

  void* data;		/* Arbitrary data for specific implementation. */
} webbase_hook_params_t;

#endif /* _webbase_hooks_h */
