/*
 *   Copyright (C) 1997, 1998
 *   	Free Software Foundation, Inc.
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#include <getopttools.h>
#include <file_exists.h>
#include <file_size.h>
#include <rm.h>
#include <find.h>
#include <salloc.h>
#include <logfile.h>

#define MAX_OPTIONS 100
#define APPLICATION_OPTIONS		0x8000000

typedef struct html2text_params {
  char* filter;
  char* log;
  char* dir;
  int size_current;
  int size_max;
  char file_current[32];
  int file_number;
} html2text_params_t;

static html2text_params_t params;

static int verbose = 0;

static void init(int argc, char** argv);
static void finish();
static void dump_data(char* path, char* dir, char* file);

int main(int argc, char** argv)
{
  init(argc, argv);

  strcpy(params.file_current, "raw.0000");
  if(file_exists(params.file_current))
    rm(params.file_current);
  if(params.dir == 0) {
    fprintf(stderr, "missing -dir option");
    exit(1);
  }
  find(params.dir, dump_data);
  finish();

  return 0;
}

static void dump_data(char* path, char* dir, char* file) {}
#if 0
static void dump_data(char* path, char* dir, char* file)
{
  if(params.filter && !strstr(path, params.filter)) return;
  if(verbose) fprintf(stderr, "%s\n", path);
  bodyparse(path, params.file_current, path, 1000000, 0, BODY_PARSE_TRANSPARENT | BODY_PARSE_APPEND);

  if(params.size_current > params.size_max) {
    params.file_number++;
    sprintf(params.file_current, "raw.%04d", params.file_number);
    if(file_exists(params.file_current))
      rm(params.file_current);
    params.size_current = 0;
  }
  params.size_current = file_size(params.file_current);
}
#endif

static void init(int argc, char** argv)
{
  static struct option long_options[MAX_OPTIONS + 1] =
  {
    /* These options set a flag. */
    {"verbose", 0, &verbose, 1},
    {"log", 1, 0, 0},
    {"filter", 1, 0, 0},
    {"dir", 1, 0, 0},
    {"size_max", 1, 0, 0},
    {0, MAX_OPTIONS, 0, APPLICATION_OPTIONS}
  };

  params.size_max = 1 * 1024 * 1024;

  optind = 0;
  while(1) {
    /* `getopt_long' stores the option index here. */
    int option_index = 0;
    int c;

    c = getopt_long_only(argc, argv, "", long_options, &option_index);

    /* Detect the end of the options. */
    if (c == -1)
      break;
     
    switch (c)
      {
      case 0:
	/* If this option set a flag, do nothing else now. */
	if (long_options[option_index].flag != 0)
	  break;
	if(!strcmp(long_options[option_index].name, "log")) {
	  params.log = strdup(optarg);
	} else if(!strcmp(long_options[option_index].name, "filter")) {
	  params.filter = strdup(optarg);
	} else if(!strcmp(long_options[option_index].name, "dir")) {
	  params.dir = strdup(optarg);
	} else if(!strcmp(long_options[option_index].name, "size_max")) {
	  params.size_max = atoi(optarg);
	} else if(!strcmp(long_options[option_index].name, "")) {
	}
	break;
      default:
	fprintf(stderr, "option parse error %c, 0x%x\n", c & 0xff, c);
	exit(1);
      }
  }

  if(params.log) logfile(params.log);

  if(verbose) getopt_dump(long_options);

  return;
}

void finish()
{
  if(params.log) free(params.log);
  if(params.filter) free(params.filter);
  if(params.dir) free(params.dir);
  exit(0);
}
