/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STLIB_H */
#include <stdio.h>
#if HAVE_STRING_H
# include <string.h>
# include <memory.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

#include <strsubs.h>
#include <salloc.h>

static int verbose = 0;

typedef struct match {
  char* where;
  int from_length;
  char* to;
  int to_length;
} match_t;

static int match_compare(const void* a, const void* b)
{
  match_t* i = (match_t*)a;
  match_t* j = (match_t*)b;
  if (i->where > j->where)
    return (1);
  if (i->where < j->where)
    return (-1);
  return (0);
}

char* strsubs(char* string, int string_size, int* size, char** from_array, char** to_array)
{
  static char* tmp = 0;
  static int tmp_size = 0;
  match_t* matches = 0;
  int matches_size = 0;
  int matches_length = 0;
  int array_size = 0;
  int substitute_size = 0;

  {
    char** p = from_array;
    int to_size = 0;
    while(*p++)
      array_size++;
    p = to_array;
    while(*p++)
      to_size++;
    if(to_size != array_size) {
      fprintf(stderr, "string_substitute: to array is %d long and from array is %d long, should be the same size\n", array_size, to_size);
      return 0;
    }
  }

  if(verbose > 5) fprintf(stderr, "string_substitute: working on %.*s\n", string_size, string);

  static_alloc((char**)&matches, &matches_size, array_size * sizeof(match_t) * 2);
  
  {
    char** from_pointer;
    char** to_pointer;
    for(from_pointer = from_array, to_pointer = to_array;
	*from_pointer;
	to_pointer++, from_pointer++) {
      char* from = *from_pointer;
      int from_length = strlen(from);
      char* to = *to_pointer;
      int to_length = strlen(to);
      int matches_count = 0;
      char* match;
      char* p;
      for(p = string; (match = strstr(p, from)); p = match + from_length) {
	static_alloc((char**)&matches, &matches_size, (matches_length + 1) * sizeof(match_t));
	matches[matches_length].where = match;
	matches[matches_length].from_length = from_length;
	matches[matches_length].to = to;
	matches[matches_length].to_length = to_length;
	if(verbose > 5) {
	  fprintf(stderr, "string_substitute: found '%.*s' at %d\n", from_length, match, match - string);
	}
	matches_length++;
	matches_count++;
      }
      substitute_size += matches_count * to_length;
    }
  }
  
  static_alloc((char**)&tmp, &tmp_size, string_size + substitute_size + 1);

  qsort((void*)matches, matches_length, sizeof(match_t), match_compare);

  {
    int index;
    char* string_pointer = string;
    char* tmp_pointer = tmp;
    for(index = 0; index < matches_length; index++) {
      match_t* match = &matches[index];
      int as_is_length = match->where - string_pointer;
      if(verbose > 5) {
	fprintf(stderr, "string_substitute: sub '%.*s' by '%s' at %d\n", match->from_length, match->where, match->to, match->where - string);
      }
      if(string_pointer > match->where) {
	fprintf(stderr, "string_substitute: string_pointer %s > match->where %s\n", string_pointer, match->where);
	exit(1);
      }
      memcpy(tmp_pointer, string_pointer, as_is_length);
      tmp_pointer += as_is_length;
      memcpy(tmp_pointer, match->to, match->to_length);
      tmp_pointer += match->to_length;
      string_pointer = match->where + match->from_length;
      if(string_pointer > string + string_size) {
	fprintf(stderr, "string_substitute: string_pointer beyond end of string while working on %.*s of length %d\n", string_size, string, string_size);
	exit(1);
      }
    }
    memcpy(tmp_pointer, string_pointer, string_size - (string_pointer - string));
    tmp_pointer[string_size - (string_pointer - string)] = '\0';
  }

  free(matches);

  *size = strlen(tmp);

  return tmp;
}
