.\" dpkg manual page - deb-control(5)
.\"
.\" Copyright © 1995 Raul Miller, Ian Jackson, Ian Murdock
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2007-2011, 2013-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2012 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH deb\-control 5 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
deb\-control \- Dateiformat der Hauptsteuerdatei von binären Debian\-Paketen
.
.SH ÜBERSICHT
control
.
.SH BESCHREIBUNG
Jedes binäre Debian\-Paket enthält die Hauptsteuerdatei \fIcontrol\fP, die eine
Reihe von Feldern enthält. Jedes Feld beginnt mit einer Markierung, wie
\fBPackage\fP oder \fBVersion\fP (Groß\-/Kleinschreibung egal), gefolgt von einem
Doppelpunkt und dem Körper des Feldes. Felder werden nur durch die
Feldmarkierungen abgegrenzt. Mit anderen Worten, Feldtexte können mehrere
Zeilen überspannen, aber die Installationswerkzeuge werden im Allgemeinen
die Zeilen bei der Verarbeitung des Feldkörpers zusammenfassen (mit Ausnahme
des \fBDescription\fP\-Feldes, sehen Sie dazu unten).
.
.SH FELDER
.TP 
\fBPackage:\fP \fIPaketname\fP (verpflichtend)
Der Wert dieses Feldes bestimmt den Paketnamen und wird von den meisten
Installationswerkzeugen verwendet, um Dateinamen zu erstellen.
.TP 
\fBVersion:\fP \fIVersionszeichenkette\fP (verpflichtend)
Typischerweise ist das die Original\-Paketversionsnummer, in der Form, die
der Programmautor verwendet. Es kann auch eine Debian\-Revisionsnummer
enthalten (für nicht aus Debian stammende Pakete). Das genaue Format und der
Sortieralgorithmus sind in \fBdeb\-version\fP(5) beschrieben.
.TP 
\fBMaintainer:\fP \fIVollständiger\-Name\-und\-E\-Mail\fP (empfohlen)
Sollte in dem Format „Joe Bloggs <jbloggs@foo.com>“ sein und ist
typischerweise die Person, die das Paket erstellt hat, im Gegensatz zum
Autor der Software, die paketiert wurde.
.TP 
\fBDescription:\fP \fIKurzbeschreibung\fP (empfohlen)
.TQ
\fB \fP\fILangbeschreibung\fP
.br
Das Format der Paketbeschreibung ist eine kurze knappe Zusammenfassung auf
der ersten Zeile (nach dem Feld \fBDescription\fP). Die folgenden Zeilen
sollten als längere, detailliertere Beschreibung verwendet werden. Jede
Zeile der Langbeschreibung muss von einem Leerzeichen begonnen werden, und
Leerzeilen in der Langbeschreibung müssen einen einzelnen ‚\fB.\fP’ hinter dem
einleitenden Leerzeichen enthalten.
.TP 
\fBSection:\fP\fI Sektion\fP
Dies ist ein allgemeines Feld, das dem Paket eine Kategorie gibt, basierend
auf der Software, die es installiert. Einige übliche Sektionen sind
\fButils\fP, \fBnet\fP, \fBmail\fP, \fBtext\fP, \fBx11\fP usw.
.TP 
\fBPriority:\fP\fI Priorität\fP
Setzt die Bedeutung dieses Pakets in Bezug zu dem Gesamtsystem. Übliche
Prioritäten sind \fBrequired\fP, \fBstandard\fP, \fBoptional\fP, \fBextra\fP usw.
.LP
Die Felder \fBSection\fP und \fBPriority\fP haben eine definierte Menge an Werten,
abhängig von den jeweiligen Distributionsrichtlinien.
.
.TP 
\fBInstalled\-Size:\fP Größe
Die ungefähre Gesamtgröße der vom Paket installierten Dateien, in Einheiten
von KiB.
.
.TP 
\fBEssential:\fP \fByes\fP|\fBno\fP
Dieses Feld wird normalerweise nur benötigt, wenn die Antwort \fByes\fP
lautet. Es bezeichnet ein Paket, das für den ordnungsgemäßen Betrieb des
Systems benötigt wird. Dpkg oder jedes andere Installationswerkzeug wird es
nicht erlauben, ein \fBEssential\fP\-Paket zu entfernen (zumindestens nicht ohne
die Verwendung einer der »force«\-Optionen).
.TP 
\fBBuild\-Essential:\fP \fByes\fP|\fBno\fP
Dieses Feld wird normalerweise nur benötigt, wenn die Antwort \fByes\fP lautet
und es wird typischerweise durch die Archivsoftware eingefügt. Es vermerkt
ein Paket, das zum Bau anderer Pakete benötigt wird.
.TP 
\fBArchitecture:\fP \fIarch\fP|\fBall\fP (empfohlen)
Die Architektur spezifiziert den Hardwaretyp für den dieses Paket kompiliert
wurde. Geläufige Architekturen sind \fBamd64\fP, \fBarmel\fP, \fBi386\fP, \fBpowerpc\fP
usw. Beachten Sie, dass der Wert \fBall\fP für Pakete gedacht ist, die
Architektur\-unabhängig sind. Einige Beispiele hierfür sind Shell\- und
Perl\-Skripte und Dokumentation.
.TP 
\fBOrigin:\fP\fI Name\fP
Der Name der Distribution, aus der dieses Paket ursprünglich stammt.
.TP 
\fBBugs:\fP\fI URL\fP
Die \fIURL\fP der Fehlerdatenbank für dieses Paket. Das derzeit verwendete
Format ist \fIBTS\-Art\fP\fB://\fP\fIBTS\-Adresse\fP wie in
\fBdebbugs://bugs.debian.org\fP.
.TP 
\fBHomepage:\fP\fI URL\fP
Die \fIURL\fP des Original\- (Upstream\-)Projekts.
.TP 
\fBTag:\fP \fI Liste\-von\-Markierungen\fP
Liste der unterstützten Markierungen (»Tags«), die die Eigenschaften des
Pakets beschreiben. Die Beschreibung und die Liste der unterstützten
Markierungen kann in dem Paket \fBdebtags\fP gefunden werden.
.TP 
\fBMulti\-Arch:\fP \fBno\fP|\fBsame\fP|\fBforeign\fP|\fBallowed\fP
Dieses Feld wird zum Anzeigen verwandt, wie sich das Paket auf einer
Multi\-Arch\-Installation verhalten soll.
.RS
.TP 
\fBno\fP
Dieser Wert ist die Vorgabe, falls das Feld nicht angegeben ist. In diesem
Fall ist das Hinzufügen des Feldes mit dem expliziten Wert \fBno\fP im
allgemeinen nicht notwendig.
.TP 
\fBsame\fP
Das Paket ist mit sich selbst koinstallierbar, darf aber nicht dazu verwandt
werden, die Abhängigkeit irgendeines Pakets von einer anderen Architektur
auf sich zu erfüllen.
.TP 
\fBforeign\fP
Das Paket ist nicht mit sich selbst koinstallierbar, aber es sollte erlaubt
sein, die nichtarchitekturabhängige Abhängigkeit eines Pakets von einer
anderen Architektur auf sich zu erfüllen (falls eine Abhängigkeit explizit
architekturqualifiziert wurde, dann wird der Wert \fBforeign\fP ignoriert).
.TP 
\fBallowed\fP
Dies erlaubt es inversen Abhängigkeiten, in ihrem Feld \fBDepends\fP
anzuzeigen, dass sie Pakete von einer fremden Architektur akzeptieren, indem
sie den Paketnamen mit \fB:any\fP qualifizieren. Hat weiter keinen Effekt.
.RE
.TP 
\fBSource:\fP \fIQuellname\fP [\fB(\fP\fIQuellversion\fP\fB)\fP]
Der Name des Quellpakets, aus dem dieses Binärpaket stammt, falls es sich
vom Namen des Pakets selbst unterscheidet. Falls die Quellversion sich von
der Binärversion unterscheidet, folgt dem \fIQuellnamen\fP in Klammern eine
\fIQuellversion\fP. Dies kann zum Beispiel bei einem rein\-binären, nicht
Betreuer\-Upload passieren, oder wenn mittels »\fBdpkg\-gencontrol \-v\fP« eine
andere Binärversion gesetzt wird.
.TP 
\fBSubarchitecture:\fP \fI Wert\fP
.TQ
\fBKernel\-Version:\fP \fI Wert\fP
.TQ
\fBInstaller\-Menu\-Item:\fP \fI Wert\fP
Diese Felder werden im Debian\-Installer verwandt und werden normalerweise
nicht benötigt. Lesen Sie /usr/share/doc/debian\-installer/devel/modules.txt
aus dem Paket \fBdebian\-installer\fP für weitere Informationen über sie.

.TP 
\fBDepends:\fP \fI Paketliste\fP
Liste von Paketen, die benötigt werden, damit dieses Paket eine
nicht\-triviale Menge an Funktionen anbieten kann. Die
Paketverwaltungssoftware wird es nicht erlauben, dass ein Paket installiert
wird, falls die in seinem \fBDepends\fP\-Feld aufgeführten Pakete nicht
installiert sind (zumindestens nicht ohne Verwendung der
»Force«\-Optionen). Bei einer Installation werden Postinst\-Skripte von
Paketen, die im Feld \fBDepends\fP aufgeführt sind, vor den Postinst\-Skripten
der eigentlichen Pakete ausgeführt. Bei der gegenteiligen Operation, der
Paket\-Entfernung, wird das Prerm\-Skript eines Paketes vor den Prerm\-Skripten
der Pakete ausgeführt, die im Feld \fBDepends\fP aufgeführt sind.
.TP 
\fBPre\-Depends:\fP \fI Paketliste\fP
Liste an Paketen die installiert \fBund\fP konfiguriert sein müssen, bevor
dieses Paket installiert werden kann. Dies wird normalerweise in dem Fall
verwendet, wo dieses Paket ein anderes Paket zum Ausführen seines
preinst\-Skriptes benötigt.
.TP 
\fBRecommends:\fP \fI Paketliste\fP
Liste an Paketen, die in allen, abgesehen von ungewöhnlichen, Installationen
zusammen angefunden würden. Die Paketverwaltungssoftware wird den Benutzer
warnen, falls er ein Paket ohne die im \fBRecommends\fP\-Feld aufgeführten
Pakete installiert.
.TP 
\fBSuggests:\fP \fI Paketliste\fP
Liste an Paketen die einen Bezug zu diesem haben und vielleicht seine
Nützlichkeit erweitern könnten, aber ohne die das zu installierende Paket
perfekt sinnvoll ist.
.LP
Die Syntax der \fBDepends\fP, \fBPre\-Depends\fP, \fBRecommends\fP und
\fBSuggests\fP\-Felder ist eine Liste von Gruppen von alternativen Paketen. Jede
Gruppe ist eine Liste von durch vertikale Striche (oder „Pipe“\-Symbole)
‚\fB|\fP’ getrennte Pakete. Die Gruppen werden durch Kommata getrennt. Kommata
müssen als „UND“, vertikale Striche als „ODER“ gelesen werden, wobei die
vertikalen Striche stärker binden. Jeder Paketname wird optional gefolgt von
einer Architektur\-Spezifikation, die nach einem Doppelpunkt »:« angehängt
wird, optional gefolgt von einer Versionsnummer\-Spezifikation in Klammern.
.LP
Eine Architektur\-Spezifikation kann eine echte Debian\-Architektur sein (seit
Dpkg 1.16.5) oder \fBany\fP (seit Dpkg 1.16.2). Falls sie fehlt, ist die
Vorgabe die aktuelle Programmpaketarchitektur. Ein echter
Debian\-Architekturname wird genau auf diese Architektur für diesen
Paketnamen passen, \fBany\fP wird auf jede Architektur für diesen Paketnamen
passen, falls das Paket als \fBMulti\-Arch: allowed\fP markiert wurde.
.LP
Eine Versionsnummer kann mit ‚\fB>>\fP’ beginnen, in diesem Falle
passen alle neueren Versionen, und kann die Debian\-Paketrevision (getrennt
durch einen Bindestrich) enthalten oder auch nicht. Akzeptierte
Versionsbeziehungen sind ‚\fB>>\fP’ für größer als, ‚\fB<<\fP’ für
kleiner als, ‚\fB>=\fP’ für größer als oder identisch zu, ‚\fB<=\fP’ für
kleiner als oder identisch zu und ‚\fB=\fP’ für identisch zu.
.TP 
\fBBreaks:\fP \fI Paketliste\fP
Liste Paketen auf, die von diesem Paket beschädigt werden, zum Beispiel in
dem sie Fehler zugänglich machen, wenn sich das andere Paket auf dieses
Paket verlässt. Die Paketverwaltungssoftware wird es beschädigten Paketen
nicht erlauben, sich zu konfigurieren; im Allgemeinen wird das Problem
behoben, indem ein Upgrade des im \fBBreaks\fP\-Feld aufgeführten Pakets
durchgeführt wird.
.TP 
\fBConflicts:\fP \fI Paketliste\fP
Liste an Paketen, die mit diesem in Konflikt stehen, beispielsweise indem
beide Dateien den gleichen Namen enthalten. Die Paketverwaltungssoftware
wird es nicht erlauben, Pakete, die in Konflikt stehen, gleichzeitig zu
installieren. Zwei in Konflikt stehende Pakete sollten jeweils eine
\fBConflicts\fP\-Zeile enthalten, die das andere Paket erwähnen.
.TP 
\fBReplaces:\fP \fIPaketliste\fP
Liste an Paketen, von denen dieses Dateien ersetzt. Dies wird dazu
verwendet, um diesem Paket zu erlauben, Dateien von einem anderen Paket zu
ersetzen und wird gewöhnlich mit dem \fBConflicts\fP\-Feld verwendet, um die
Entfernung des anderen Paketes zu erlauben, falls dieses auch die gleichen
Dateien wie das im Konflikt stehende Paket hat.
.LP
Die Syntax von \fBBreaks\fP, \fBConflicts\fP und \fBReplaces\fP ist eine Liste von
Paketnamen, getrennt durch Kommata (und optionalen Leerraumzeichen). Im
\fBBreaks\fP\- und \fBConflicts\fP\-Feld sollte das Komma als „ODER“ gelesen
werden. Eine optionale Architektur\-Spezifikation kann mit der gleichen
Syntax wie oben an den Paketnamen angehängt werden; der Vorgabewert ist
allerdings \fBany\fP statt der Architektur des Programms. Eine optionale
Version kann auch mit der gleichen Syntax wie oben für die \fBBreaks\fP\-,
\fBConflicts\fP\- und \fBReplaces\fP\-Felder angegeben werden.
.
.TP 
\fBProvides:\fP \fI Paketliste\fP
Dies ist eine Liste von virtuellen Paketen, die dieses Paket
bereitstellt. Gewöhnlich wird dies verwendet, wenn mehrere Pakete alle den
gleichen Dienst bereitstellen. Beispielsweise können Sendmail und Exim als
Mailserver dienen, daher stellen sie ein gemeinsames Paket
(„mail\-transport\-agent“) bereit, von dem andere Pakete abhängen können. Dies
erlaubt es Sendmail oder Exim als gültige Optionen zur Erfüllung der
Abhängigkeit zu dienen. Dies verhindert, dass Pakete, die von einem
E\-Mail\-Server abhängen, alle Paketnamen für alle E\-Mail\-Server wissen und
‚\fB|\fP’ zur Unterteilung der Liste verwenden müssen.
.LP
Die Syntax von \fBProvides\fP ist eine Liste von Paketnamen, getrennt durch
Kommata (und optionalen Leerraumzeichen). Eine optionale
Architektur\-Spezifikation kann mit der gleichen Syntax wie oben an den
Paketnamen angehängt werden. Falls diese fehlt, ist die Vorgabe die binäre
Paketarchitektur. Eine optionale genaue (identisch mit) Version kann auch
mit der gleichen Syntax wie oben angegeben werden (seit Dpkg 1.17.11
berücksichtigt).
.
.TP 
\fBBuilt\-Using:\fP \fI Paketliste\fP
Dieses Feld führt zusätzliche Quellpakete auf, die während des Baus des
Binärpakets verwandt wurden. Dies dient als Hinweis für die
Archivverwaltungssoftware, dass zusätzliche Quellpakete vorhanden bleiben
müssen, während dieses Binärpaket betreut wird. Dieses Feld muss eine Liste
von Quellpaketnamen enthalten, bei denen eine strenge Versionsbeziehung
‚\fB=\fP’ angegeben ist. Beachten Sie, dass die Archivverwaltungssoftware
wahrscheinlich einen Upload ablehnen wird, bei dem eine
\fBBuilt\-Using\fP\-Beziehung angegeben wurde, die innerhalb des Archivs nicht
erfüllt werden kann.
.
.TP 
\fBBuilt\-For\-Profiles:\fP\fI Profilliste\fP
Das Feld gibt eine durch Leerraum getrennte Liste von Bauprofilen an, unter
denen dieses Paket gebaut wurde.
.
.SH BEISPIEL
.\" .RS
.nf
# Comment
Package: grep
Essential: yes
Priority: required
Section: base
Maintainer: Wichert Akkerman <wakkerma@debian.org>
Architecture: sparc
Version: 2.4\-1
Pre\-Depends: libc6 (>= 2.0.105)
Provides: rgrep
Conflicts: rgrep
Description: GNU grep, egrep und fgrep.
 Die GNU\-Familie der Grep\-Werkzeuge könnte die »schnellste im Westen« sein.
 GNU Grep basiert auf einem schellen »lazy\-state deterministic matcher«
 (rund zweimal so schnell wie der standardmäßige Unix\-Egrep) hybridisiert
 mit einer Boyer\-Moore\-Gosper\-Suche für eine feste Zeichenkette, die
 unmöglichen Text von der Betrachtung durch den vollen »Matcher« verhindert
 ohne notwendigerweise jedes Zeichen anzuschauen. Das Ergebnis ist
 typischerweise um ein mehrfaches Schneller als Unix Grep oder Egrep.
 (Reguläre Ausdrücke, die Rückreferenzierungen enthalten, werden allerdings
 langsamer laufen.)
.fi
.\" .RE
.
.SH "SIEHE AUCH"
\fBdeb\fP(5), \fBdeb\-version\fP(5), \fBdebtags\fP(1), \fBdpkg\fP(1), \fBdpkg\-deb\fP(1).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2016 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
