.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gensymbols 1 %RELEASE_DATE% %VERSION% "Herramientas de dpkg"
.nh
.SH NOMBRE
dpkg\-gensymbols \- Generación de ficheros «symbols» (información de
dependencia de bibliotecas compartidas)
.
.SH SINOPSIS
\fBdpkg\-gensymbols\fP [\fIopción\fP...]
.
.SH DESCRIPCIÓN
\fBdpkg\-gensymbols\fP analiza un árbol temporal de construcción («debian/tmp»
por omisión) en busca de bibliotecas para generar un fichero \fIsymbols\fP que
los describa. Este fichero, si no está vacío, se instala en el subdirectorio
«DEBIAN» del árbol de construcción, para después incluir el contenido en la
información de control del paquete.
.P
Al generar estos ficheros, usa algunos ficheros «symbols» como entrada
proporcionados por el desarrollador. Busca los siguientes ficheros,
utilizando el primero que encuentra.
.IP • 4
debian/\fIpackage\fP.symbols.\fIarch\fP
.IP • 4
debian/symbols.\fIarch\fP
.IP • 4
debian/\fIpackage\fP.symbols
.IP • 4
debian/symbols
.P
The main interest of those files is to provide the minimal version
associated to each symbol provided by the libraries. Usually it corresponds
to the first version of that package that provided the symbol, but it can be
manually incremented by the maintainer if the ABI of the symbol is extended
without breaking backwards compatibility. It's the responsibility of the
maintainer to keep those files up\-to\-date and accurate, but
\fBdpkg\-gensymbols\fP helps with that.
.P
Cuando los ficheros «symbols» generados difieren del proporcionado por el
desarrollador, \fBdpkg\-gensymbols\fP mostrará las diferencias entre ambas
versiones. Más aún, puede que falle si la diferencia es demasiado grande,
(puede configurar cuanta diferencia tolerar, consulte la opción \fB\-c\fP).
.SH "MANTENER FICHEROS «SYMBOLS»"
The symbols files are really useful only if they reflect the evolution of
the package through several releases. Thus the maintainer has to update them
every time that a new symbol is added so that its associated minimal version
matches reality.  The diffs contained in the build logs can be used as a
starting point, but the maintainer, additionally, has to make sure that the
behaviour of those symbols has not changed in a way that would make anything
using those symbols and linking against the new version, stop working with
the old version.  In most cases, the diff applies directly to the
debian/\fIpackage\fP.symbols file. That said, further tweaks are usually
needed: it's recommended for example to drop the Debian revision from the
minimal version so that backports with a lower version number but the same
upstream version still satisfy the generated dependencies.  If the Debian
revision can't be dropped because the symbol really got added by the Debian
specific change, then one should suffix the version with ‘\fB~\fP’.
.P
Antes de aplicar un parche al fichero «symbols» el desarrollador debería
revisar nuevamente que es adecuado. Se espera que los símbolos públicos no
desaparezcan así que, idealmente, el parche sólo debería añadir líneas
nuevas.
.P
Note that you can put comments in symbols files: any line with ‘#’ as the
first character is a comment except if it starts with ‘#include’ (see
section \fBUsing includes\fP).  Lines starting with ‘#MISSING:’ are special
comments documenting symbols that have disappeared.
.P
Do not forget to check if old symbol versions need to be increased.  There
is no way \fBdpkg\-gensymbols\fP can warn about this. Blindly applying the diff
or assuming there is nothing to change if there is no diff, without checking
for such changes, can lead to packages with loose dependencies that claim
they can work with older packages they cannot work with. This will introduce
hard to find bugs with (partial)  upgrades.
.SS "Usar la sustitución de #PACKAGE#"
.P
En algunos casos aislados el nombre de la biblioteca varía según la
arquitectura. Puede utilizar el marcador \fI#PACKAGE#\fP para evitar incrustar
(«hardcode») el nombre del paquete en el fichero «symbols». Se reemplazará
por el nombre real del paquete durante la instalación de los ficheros
«symbols». A diferencia del marcador \fI#MINVER#\fP, \fI#PACKAGE#\fP nunca
aparecerá en un fichero «symbols» contenido en un paquete binario.
.SS "Usar etiquetas de símbolos"
.P
Symbol tagging is useful for marking symbols that are special in some way.
Any symbol can have an arbitrary number of tags associated with it. While
all tags are parsed and stored, only some of them are understood by
\fBdpkg\-gensymbols\fP and trigger special handling of the symbols. See
subsection \fBStandard symbol tags\fP for reference of these tags.
.P
La especificación de la etiqueta aparece a continuación del nombre del
símbolo (no se permite un espacio vacío entre estos). Siempre comienza con
un paréntesis de apertura \fB(\fP, finaliza con un paréntesis de cierre \fB)\fP, y
debe contener al menos una etiqueta. Varias etiquetas se separan con un
carácter \fB|\fP. Opcionalmente, cada etiqueta puede tener un valor separado
del nombre de la etiqueta mediante el carácter \fB=\fP. Los nombres de etiqueta
y valores pueden ser cadenas arbitrarias, a excepción de que no pueden
contener ningún carácter especial: \fB)\fP, \fB|\fP y \fB=\fP. Los nombres de símbolo
a continuación de una especificación de etiqueta se pueden entrecomillar con
caracteres \fB'\fP o \fB"\fP, permitiendo así espacios vacíos. Por otra parte, de
no existir ninguna etiqueta definida para el símbolo, las comillas se
tratarán como parte del nombre del símbolo, continuando hasta el primer
espacio.
.P
 (tag1=tengo una marca|nombre de etiqueta con espacio)"símbolo
 entrecomillado y etiquetado"@Base 1.0
 (optional)símbolo_sin_comillas_y_etiquetado@Base 1.0 1
 símbolo_sin_etiquetar@Base 1.0
.P
El primer símbolo del ejemplo se llama \fIsímbolo entrecomillado y
etiquetado\fP, y tiene dos etiquetas: \fItag1\fP, con el valor \fItengo una marca\fP
y \fInombre de etiqueta con espacio\fP, que no tiene valor. El segundo símbolo
se llama \fIsímbolo_sin_comillas_y_etiquetado\fP, y sólo tiene una etiqueta
llamada \fIoptional\fP. El último símbolo es un ejemplo de un símbolo normal
sin etiquetar.
.P
Since symbol tags are an extension of the \fBdeb\-symbols\fP(5) format, they can
only be part of the symbols files used in source packages (those files
should then be seen as templates used to build the symbols files that are
embedded in binary packages). When \fBdpkg\-gensymbols\fP is called without the
\fB\-t\fP option, it will output symbols files compatible to the
\fBdeb\-symbols\fP(5) format: it fully processes symbols according to the
requirements of their standard tags and strips all tags from the output. On
the contrary, in template mode (\fB\-t\fP) all symbols and their tags (both
standard and unknown ones)  are kept in the output and are written in their
original form as they were loaded.
.SS "Etiquetas de símbolo estándar"
.TP 
\fBoptional\fP
A symbol marked as optional can disappear from the library at any time and
that will never cause \fBdpkg\-gensymbols\fP to fail. However, disappeared
optional symbols will continuously appear as MISSING in the diff in each new
package revision.  This behaviour serves as a reminder for the maintainer
that such a symbol needs to be removed from the symbol file or readded to
the library. When the optional symbol, which was previously declared as
MISSING, suddenly reappears in the next revision, it will be upgraded back
to the “existing” status with its minimum version unchanged.

Esta etiqueta es útil para aquellos símbolos privados cuya desaparición no
rompe la ABI. Por ejemplo, la mayoría de plantillas de producción de un
objeto definido más específicamente por medio del reemplazo de ciertas
variables por valores («instantiation») de C++ se encuentran dentro de esta
categoría. Al igual que con cualquier otra etiqueta, éste puede tener un
valor arbitrario: se puede utilizar para indicar porqué el símbolo se
considera opcional.
.TP 
\fBarch=\fP\fIarchitecture\-list\fP
.TQ
\fBarch\-bits=\fP\fIarchitecture\-bits\fP
.TQ
\fBarch\-endian=\fP\fIarchitecture\-endianness\fP
These tags allow one to restrict the set of architectures where the symbol
is supposed to exist. The \fBarch\-bits\fP and \fBarch\-endian\fP tags are supported
since dpkg 1.18.0. When the symbols list is updated with the symbols
discovered in the library, all arch\-specific symbols which do not concern
the current host architecture are treated as if they did not exist. If an
arch\-specific symbol matching the current host architecture does not exist
in the library, normal procedures for missing symbols apply and it may cause
\fBdpkg\-gensymbols\fP to fail. On the other hand, if the arch\-specific symbol
is found when it was not supposed to exist (because the current host
architecture is not listed in the tag or does not match the endianness and
bits), it is made arch neutral (i.e. the arch, arch\-bits and arch\-endian
tags are dropped and the symbol will appear in the diff due to this change),
but it is not considered as new.

Al operar en el modo por omisión (sin plantilla) sólo se escribirán al
fichero «symbols» aquellos símbolos específicos a la arquitectura que
coinciden con la arquitectura anfitrión. Por otra parte, en el modo
plantilla todos los símbolos específicos a la arquitectura (incluyendo
arquitecturas alternativas) siempre se escribirán al fichero «symbols».

The format of \fIarchitecture\-list\fP is the same as the one used in the
\fBBuild\-Depends\fP field of \fIdebian/control\fP (except the enclosing square
brackets []). For example, the first symbol from the list below will be
considered only on alpha, any\-amd64 and ia64 architectures, the second only
on linux architectures, while the third one anywhere except on armel.

 (arch=alpha any\-amd64 ia64)64bit_símbolo_específico@Base 1.0
 (arch=linux\-any)símbolo_específico_linux@Base 1.0
 (arch=!armel)símbolo_ausente_en_armel@Base 1.0

The \fIarchitecture\-bits\fP is either \fB32\fP or \fB64\fP.

 (arch\-bits=32)32bit_specific_symbol@Base 1.0
 (arch\-bits=64)64bit_specific_symbol@Base 1.0

The \fIarchitecture\-endianness\fP is either \fBlittle\fP or \fBbig\fP.

 (arch\-endian=little)little_endian_specific_symbol@Base 1.0
 (arch\-endian=big)big_endian_specific_symbol@Base 1.0

Multiple restrictions can be chained.

 (arch\-bits=32|arch\-endian=little)32bit_le_symbol@Base 1.0
.TP 
\fBignore\-blacklist\fP
dpkg\-gensymbols tiene una lista negra interna de símbolos que no deberían
aparecer en los ficheros «symbols», ya que habitualmente son sólo efectos
secundarios de los detallas de implementación de la cadena de
herramientas. Si por alguna razón desea incluir uno de esos símbolos en el
fichero «symbols» debería etiquetar el símbolo con
\fBignore\-blacklist\fP. Puede ser necesario con alguna cadena de herramientas
de bajo nivel como libgcc.
.TP 
\fBc++\fP
Denota el patrón \fIc++\fP\- Consulte la subsección a continuación \fBUsar
patrones de símbolos\fP.
.TP 
\fBsymver\fP
Denota el patrón de símbolos \fIsymver\fP (versión del símbolo). Consulte la
sub\-sección a continuación \fBUsar patrones de símbolos\fP.
.TP 
\fBregex\fP
Denota el patrón de símbolos \fIregex\fP (expresión regular). Consulte la
sub\-sección a continuación \fBUsar patrones de símbolos\fP.
.SS "Usar patrones de símbolos"
.P
A diferencia de cualquier definición de símbolo estándar un patrón puede
cubrir varios símbolos reales de la biblioteca. \fBdpkg\-gensymbols\fP intentará
emparejar cada patrón con cada símbolo real que \fIno\fP tiene un símbolo
específico de contrapartida definido en el fichero de símbolos. En el
momento que se encuentre el primer patrón que coincida se usarán todas sus
etiquetas y propiedades como un definición básica del símbolo. Si ninguno de
los patrones encaja, el símbolo se considerará nuevo.

A pattern is considered lost if it does not match any symbol in the
library. By default this will trigger a \fBdpkg\-gensymbols\fP failure under
\fB\-c1\fP or higher level. However, if the failure is undesired, the pattern
may be marked with the \fIoptional\fP tag. Then if the pattern does not match
anything, it will only appear in the diff as MISSING. Moreover, like any
symbol, the pattern may be limited to the specific architectures with the
\fIarch\fP tag. Please refer to \fBStandard symbol tags\fP subsection above for
more information.

Patterns are an extension of the \fBdeb\-symbols\fP(5) format hence they are
only valid in symbol file templates. Pattern specification syntax is not any
different from the one of a specific symbol. However, symbol name part of
the specification serves as an expression to be matched against
\fIname@version\fP of the real symbol. In order to distinguish among different
pattern types, a pattern will typically be tagged with a special tag.

A día de hoy, \fBdpkg\-gensymbols\fP es compatible con tres tipos de patrones
básicos:
.TP  3
\fBc++\fP
Este patrón se indica con la etiqueta \fIc++\fP. Sólo encaja con el nombre
«demangled» de símbolos C++ (tal y como muestra la herramienta
\fBc++filt\fP(1)). Este patrón es de utilidad para emparejar símbolos con
nombres «mangled» que pueden variar según la arquitectura, mientras que sus
nombres «demangled» permanecen sin cambios. Un grupo de estos símbolos son
los \fIthunk no virtuales\fP, que tienen direcciones relativas («offsets»)
específicas a la arquitectura integradas en sus nombres «mangled». Un
ejemplo común de este caso es un destructor virtual, que bajo una herencia
de diamante necesita un símbolo thunk no virtual. Por ejemplo, incluso si
«_ZThn8_N3NSB6ClassDD1Ev@Base» en arquitecturas de 32bit es
«_ZThn16_N3NSB6ClassDD1Ev@Base» en arquitecturas de 64bit, puede emparejarlo
con un único patrón \fIc++\fP:

libdummy.so.1 libdummy1 #MINVER#
 [...]
 (c++)"non\-virtual thunk to NSB::ClassD::~ClassD()@Base" 1.0
 [...]

Puede obtener el nombre «demangled» del ejemplo anterior ejecutando la
siguiente orden:

 $ echo '_ZThn8_N3NSB6ClassDD1Ev@Base' | c++filt

Observe que aunque el nombre «mangled» sea por definición único en la
biblioteca, no es necesariamente cierto para nombres «demangled». Puede que
dos símbolos reales y distintos tengan el mismo nombre «demangled». Por
ejemplo, en caso de existir símbolos thunk no virtuales en complejas
configuraciones de herencia, o con la mayoría de constructores y
destructores (ya que habitualmente g++ genera dos símbolos para ellos). Por
otra parte, estas colisiones aparecen al nivel de la ABI, y por ello no
deberían degradar la calidad del fichero de símbolos.
.TP 
\fBsymver\fP
La etiqueta \fIsymver\fP indica este patrón. Las bibliotecas bien mantenidas
tienen símbolos con versión, donde cada versión corresponde con la versión
del autor original en la que se añadió el símbolo. De ser así, puede
utilizar un patrón \fIsymver\fP para emparejar el símbolo asociado con una
versión en particular. Por ejemplo:

libc.so.6 libc6 #MINVER#
 (symver)GLIBC_2.0 2.0
 [...]
 (symver)GLIBC_2.7 2.7
 access@GLIBC_2.0 2.2

Todos los símbolos asociados con las versiones «GLIBC_2.0» y «GLIBC_2.7»
llevan a una versión mínima de 2.0 y 2.7 respectivamente, con la excepción
del símbolo «access@GLIBC_2.0». El segundo lleva a una dependencia mínima
sobre la versión 2.2 de libc6, a pesar de estar en el rango del patrón
«(symver)GLIBC_2.0», debido a que los símbolos específicos tiene precedencia
sobre los patrones.

Tenga en cuanta que los patrones de comodín antiguos (indicados por
«*@versio» en el campo del nombre del símbolo) son aún compatibles, aunque
han quedado obsoletos por el nuevo estilo de sintaxis
«(symver|optional)versión». Por ejemplo, debería escribir «*@GLIBC_2.0 2.0»
como «(symver|optional)GLIBC_2.0 2.0» si desea el mismo comportamiento.
.TP 
\fBregex\fP
Los patrones de expresiones regulares se indican con la etiqueta
\fIregex\fP. Buscan coincidencias con la expresión regular de perl definido en
el campo de nombre del símbolo. Una expresión regular se empareja tal cual,
por ello no olvide insertar \fI^\fP al inicio de la misma o puede que coincida
con cualquier parte de la cadena real del símbolo \fInombre@versión\fP. Por
ejemplo:

libdummy.so.1 libdummy1 #MINVER#
 (regex)"^mystack_.*@Base$" 1.0
 (regex|optional)"private" 1.0

Los símbolos como «mystack_new@Base», «mystack_push@Base»,
«mystack_pop@Base» y similares encajarían con el primer patrón, mientras que
otros como «ng_mystack_new@Base» no lo harían. El segundo patrón encaja con
todos los símbolos con «private» en su nombre, y las coincidencias heredarán
de este patrón la etiqueta \fIoptional\fP.
.P
Puede combinar los patrones listados anteriormente, cuando tenga sentido. En
tal caso, se procesan en el orden de las etiquetas definidas. Por ejemplo,
ambos

 (c++|regex)"^NSA::ClassA::Private::privmethod\ed\e(int\e)@Base" 1.0
 (regex|c++)N3NSA6ClassA7Private11privmethod\edEi@Base 1.0

encaja con «_ZN3NSA6ClassA7Private11privmethod1Ei@Base» y
«_ZN3NSA6ClassA7Private11privmethod2Ei@Base». Al comparar el primer patrón
se «demangle» el símbolo sin procesar como símbolo C++, para después
comparar el nombre «demangled» con la expresión regular. Por otra parte, al
comparar el segundo patrón la expresión regular se compara con el nombre sin
procesar del símbolo, para después confirmar si es un símbolo de C++
mediante «demangle». Un fallo de un patrón básico lleva a un fallo de todo
el patrón. Por ejemplo, «__N3NSA6ClassA7Private11privmethod\edEi@Base» no
encajaría con ningún patrón porque no es un símbolo válido de C++.

En general, todos los patrones se dividen en dos grupos: aliases (los
básicos \fIc++\fP y \fIsymver\fP) y patrones genéricos (\fIregex\fP, todas las
combinaciones de varios patrones básicos). Establecer coincidencias con
patrones basados en alias es rápido (0(1)) mientras que los patrones
genéricos son 0(N) (N \- cuenta genérica del patrón) para cada
símbolo. Debido a ello, se recomienda no abusar de los patrones genéricos.

Los alias (primero \fIc++\fP, después \fIsymver\fP) tienen prioridad sobre los
patrones genéricos. Éstos se emparejan por orden de aparición en la
plantilla del fichero de símbolos hasta el primer resultado de éxito. Tenga
en cuenta, no obstante, que no se recomienda la reorganización manual de las
entradas en plantillas de fichero ya que \fBdpkg\-gensymbols\fP genera «diffs»
basados en el orden alfanumérico de sus nombres.
.SS "Usar «include»"
.P
Hay casos en los que utilizar un sólo fichero de símbolos es
contraproducente cuando el conjunto de símbolos exportados difiere según la
arquitectura. En estos casos, una directiva «include» puede ser útil de un
par de maneras:
.IP • 4
Puede factorizar la parte común en algún fichero externo, e incluir ese
fichero en su fichero \fIpaquete\fP.symbols.\fIarq\fP usando una directiva
«include» como esta:

#include "\fIpackages\fP.symbols.common"
.IP •
Al igual que con cualquier símbolo, puede etiquetar la directiva «include»:

(etiqueta|...|etiquetaN)#include "fichero\-para\-include"

Como resultado, se considerará que todos los símbolos incluidos en
\fIfichero\-para\-include\fP están etiquetados con \fIetiqueta\fP ... \fIetiquetaN\fP
por omisión. Puede utilizar esta característica para crear un fichero común
\fIpackage\fP.symbols, que incluye ficheros de símbolos específicos a la
arquitectura.

  common_symbol1@Base 1.0
 (arch=amd64 ia64 alpha)#include "package.symbols.64bit"
 (arch=!amd64 !ia64 !alpha)#include "package.symbols.32bit"
  common_symbol2@Base 1.0
.P
Los ficheros de símbolos se leen línea a línea, y las directivas «include»
se procesan por orden de aparición. Esto significa que el contenido del
fichero incluido puede sustituir cualquier contenido aparecido antes de la
directiva «include», y que todo contenido a continuación de la directiva
puede sustituir cualquier contenido del fichero incluido. Todo símbolo (o
incluso otra directiva «#include») en el fichero incluido puede especificar
etiquetas adicionales, o sustituir valores de las etiquetas heredadas en la
especificación de etiqueta. Por otra parte, el símbolo no puede eliminar
ninguna de las etiquetas heredadas.
.P
Un fichero incluido puede repetir la línea de cabecera que contiene el
«SONAME» de la biblioteca. En tal caso, sustituye cualquier línea de
cabecera leída anteriormente. Por otra parte, generalmente es mejor evitar
duplicar las líneas de cabecera. A continuación puede ver una manera de
realizar esto:
.PP
#include "libsomething1.symbols.common"
 arch_specific_symbol@Base 1.0
.SS "Buena gestión de bibliotecas"
.P
Una biblioteca mantenida adecuadamente tiene las siguientes características:
.IP • 4
su API es estable (los símbolos públicos nunca se eliminan, sino que sólo se
añaden símbolos nuevos), y los cambios pueden introducir una
incompatibilidad sólo cuando el «SONAME» cambia;
.IP • 4
Idealmente, usa el versionado de símbolos para alcanzar la estabilidad de la
ABI, a pesar de cambios internos y la extensión de la API;
.IP • 4
No exporta símbolos privados (tales como símbolos etiquetados como
opcionales para evitar un problema).
.P
Al mantener un fichero «symbols» es sencillo notar la aparición y
desaparición de símbolos. Pero es más difícil notar cambios incompatibles en
las API y ABI. Por ello, el responsable del paquete debería leer
cuidadosamente el registro de cambios de la fuente original en busca de
casos en los que se ha roto la correcta gestión de bibliotecas. Se debería
notificar al autor original en caso de encontrar problemas potenciales, ya
que un arreglo en la fuente original del software es siempre preferible a un
arreglo específico de Debian.
.SH OPCIONES
.TP 
\fB\-P\fP\fIdirectorio\-compilación\-paquete\fP
Analiza \fIdirectorio\-compilación\-paquete\fP en lugar de «debian/tmp».
.TP 
\fB\-p\fP\fIpaquete\fP
Define el nombre del paquete. Es necesario si aparece más de un paquete
binario en «debian/control» (o si no existe ningún fichero
«debian/control»).
.TP 
\fB\-v\fP\fIversión\fP
Define la versión del paquete. El valor por omisión es la versión extraída
de «debian/changelog». Necesario en caso de una ejecución externa al árbol
del paquete fuente.
.TP 
\fB\-e\fP\fIfichero\-biblioteca\fP
Only analyze libraries explicitly listed instead of finding all public
libraries. You can use shell patterns used for pathname expansions (see the
\fBFile::Glob\fP(3perl) manual page for details) in \fIlibrary\-file\fP to match
multiple libraries with a single argument (otherwise you need multiple
\fB\-e\fP).
.TP 
\fB\-I\fP\fInombre\-fichero\fP
Usa \fInombre\-fichero\fP como un fichero de referencia para generar el fichero
«symbols» integrado en el mismo paquete.
.TP 
\fB\-O\fP[\fIfilename\fP]
Print the generated symbols file to standard output or to \fIfilename\fP if
specified, rather than to \fBdebian/tmp/DEBIAN/symbols\fP (or
\fIpackage\-build\-dir\fP\fB/DEBIAN/symbols\fP if \fB\-P\fP was used). If \fIfilename\fP is
pre\-existing, its contents are used as basis for the generated symbols
file.  You can use this feature to update a symbols file so that it matches
a newer upstream version of your library.
.TP 
\fB\-t\fP
Write the symbol file in template mode rather than the format compatible
with \fBdeb\-symbols\fP(5). The main difference is that in the template mode
symbol names and tags are written in their original form contrary to the
post\-processed symbol names with tags stripped in the compatibility mode.
Moreover, some symbols might be omitted when writing a standard
\fBdeb\-symbols\fP(5) file (according to the tag processing rules) while all
symbols are always written to the symbol file template.
.TP 
\fB\-c\fP\fI[0\-4]\fP
Define las comprobaciones a realizar al comparar el fichero «symbols»
generado usando como base el fichero de plantilla. El nivel predefinido es
1. Aumentar los niveles conlleva más comprobaciones, así como la inclusión
de todos los niveles inferiores. El nivel 0 nunca falla. El nivel 1 falla si
algunos símbolos han desaparecido. El nivel 2 falla si se han introducido
símbolos nuevos. El nivel 3 falla si han desaparecido algunas
bibliotecas. El nivel 4 falla si se han introducido bibliotecas nuevas.

This value can be overridden by the environment variable
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP.
.TP 
\fB\-q\fP
Keep quiet and never generate a diff between generated symbols file and the
template file used as starting point or show any warnings about new/lost
libraries or new/lost symbols. This option only disables informational
output but not the checks themselves (see \fB\-c\fP option).
.TP 
\fB\-a\fP\fIarquitectura\fP
Toma \fIarquitectura\fP como la arquitectura anfitrión al procesar ficheros
«symbols». Use esta opción para generar un fichero «symbols» o un «diff»
para cualquier arquitectura, siempre y cuando sus binarios ya estén
disponibles.
.TP 
\fB\-d\fP
Activa el modo de depuración. Se muestran numerosos mensajes que explican
las acciones de \fBdpkg\-gensymbols\fP.
.TP 
\fB\-V\fP
Activa el modo verboso. El fichero «symbols» generado contiene símbolos
obsoletos en la forma de comentarios. Además, en modo plantilla los patrones
de símbolo anteceden a los comentarios que listan los símbolos reales que
coinciden con el patrón.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Muestra el modo de uso y termina.
.TP 
\fB\-\-version\fP
Muestra la versión y termina.
.
.SH "VÉASE TAMBIÉN"
\fBhttps://people.redhat.com/drepper/symbol\-versioning\fP
.br
\fBhttps://people.redhat.com/drepper/goodpractice.pdf\fP
.br
\fBhttps://people.redhat.com/drepper/dsohowto.pdf\fP
.br
\fBdeb\-symbols\fP(5), \fBdpkg\-shlibdeps\fP(1).
.SH TRADUCTOR
Rudy Godoy <rudy@kernel\-panik.org>,
Rubén Porras <nahoo@inicia.es>,
Bruno Barrera C. <bruno.barrera@igloo.cl>,
Carlos Izquierdo <gheesh@ertis.net>,
Esteban Manchado y
NOK.
Debian L10n Spanish <debian\-l10n\-spanish@lists.debian.org>.
.br
Revisiones por Santiago Vila <sanvila@unex.es>,
Javier Fernández\-Sanguino, Rubén Porras,
Luis Uribe y Omar Campagne.
