.\" dpkg manual page - dpkg-query(1)
.\"
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-query 1 %RELEASE_DATE% %VERSION% dpkg\-suite
.nh
.SH NAAM
dpkg\-query \- een gereedschap om te zoeken in de database van dpkg
.
.SH OVERZICHT
\fBdpkg\-query\fP [\fIoptie\fP...] \fIcommando\fP
.
.SH BESCHRIJVING
\fBdpkg\-query\fP is een gereedschap om informatie te tonen over pakketten die
opgenomen zijn in de database van \fBdpkg\fP.
.
.SH COMMANDO'S
.TP 
\fB\-l\fP, \fB\-\-list\fP [\fIpakketnaampatroon\fP...]
Geef de pakketten weer die beantwoorden aan het opgegeven patroon. Indien
geen \fIpakketnaampatroon\fP opgegeven werd, som dan alle pakketten uit
\fI%ADMINDIR%/status\fP op, met uitzondering van diegene die als
niet\-geïnstalleerd gemarkeerd staan (d.w.z. die welke eerder gewist
werden). De normale shell\-jokertekens mogen in \fIpakketnaampatroon\fP gebruikt
worden. Merk op dat u \fIpakketnaampatroon\fP wellicht tussen aanhalingstekens
zult moeten plaatsen om te voorkomen dat de shell aan bestandsnaamexpansie
zou doen. Het volgende zal bijvoorbeeld een opsomming geven van alle
pakketnamen die beginnen met \*(lqlibc6\*(rq:

.nf
  \fBdpkg\-query \-l 'libc6*'\fP
.fi

De eerste drie kolommen van de uitvoer tonen de gewenste actie, de toestand
van het pakket, en fouten, in die volgorde.

Gewenste actie:
.nf
  u = Onbekend (Unknown)
  i = Installeren (Install)
  h = Handhaven (Hold)
  r = Verwijderen (Remove)
  p = Wissen (Purge)
.fi

Toestand van het pakket:
.nf
  n = Niet\-geïnstalleerd (Not\-installed)
  c = Configuratiebestanden (Config\-files)
  H = Half\-geïnstalleerd (Half\-installed)
  U = Uitgepakt (Unpacked)
  F = Half\-geconfigureerd (Half\-configured)
  W = Triggers\-afgewacht (Triggers\-awaiting)
  t = Triggers\-aanhangig (Triggers\-pending)
  i = Geïnstalleerd (Installed)
.fi

Foutvlaggen:
.nf
  <leeg> = (geen)
  R = Herinst\-nodig (Reinst\-required)
.fi

Een toestand die aangeduid wordt met een hoofdletter of een foutletter
wijzen erop dat het waarschijnlijk is dat het pakket ernstige problemen zal
veroorzaken. Gelieve \fBdpkg\fP(1) te raadplegen voor informatie over de
bovenstaande toestanden en vlaggen.

De indeling van de uitvoer van deze optie kan niet geconfigureerd worden,
maar varieert automatisch om te passen binnen de breedte van de terminal. Ze
is bedoeld om door personen gelezen te worden, en kan niet gemakkelijk
gelezen worden door een machine. Zie \fB\-W\fP (\fB\-\-show\fP) en \fB\-\-showformat\fP
voor een manier om de indeling van de uitvoer te configureren.
.TP 
\fB\-W\fP, \fB\-\-show\fP [\fIpakketnaampatroon\fP...]
Net zoals de optie \fB\-\-list\fP zal dit alle pakketten opsommen die met het
opgegeven patroon overeenkomen. De uitvoer kan evenwel aangepast worden met
behulp van de optie \fB\-\-showformat\fP. De standaardindeling van de uitvoer
gebruikt één regel per pakket dat gevonden werd, waarbij elke regel de naam
(uitgebreid met de architectuurkwalificatie voor pakketten van het type
\fBMulti\-Arch\fP \fBsame\fP) en de geïnstalleerde versie van het pakket bevat,
onderling gescheiden door een tab.
.TP 
\fB\-s\fP, \fB\-\-status\fP \fIpakketnaam\fP...
Rapporteert over de status van het opgegeven pakket. Dit geeft gewoon het
item weer uit de database met de toestand van geïnstalleerde bestanden. Als
meerdere \fIpakketnamen\fP vermeld werden, worden de opgevraagde items met
toestandsinformatie van elkaar gescheiden door een lege regel en weergegeven
in dezelfde volgorde als die van de lijst met argumenten.
.TP 
\fB\-L\fP, \fB\-\-listfiles\fP \fIpakketnaam\fP...
Som de bestanden op die uit \fIpakketnaam\fP op uw systeem geïnstalleerd
werden. Als meerdere \fIpakketnamen\fP opgegeven werden, zullen de gevraagde
opsommingen van bestanden van elkaar gescheiden worden door een lege regel
en in dezelfde volgorde weergegeven worden als ze in de lijst met argumenten
opgegeven werden. Merk nochtans op dat bestanden die aangemaakt worden door
pakketspecifieke installatiescripts niet vermeld worden.
.TP 
\fB\-\-control\-list\fP \fIpakketnaam\fP
Som de controlebestanden op die uit \fIpakketnaam\fP op uw systeem
geïnstalleerd werden (sinds dpkg 1.16.5). Die kunnen gebruikt worden als
invoerargumenten voor \fB\-\-control\-show\fP.
.TP 
\fB\-\-control\-show\fP \fIpakketnaam\fP \fIcontrolebestand\fP
Geef het \fIcontrolebestand\fP dat uit \fIpakketnaam\fP op uw systeem
geïnstalleerd werd, weer op de standaarduitvoer (sinds dpkg 1.16.5).
.TP 
\fB\-c\fP, \fB\-\-control\-path\fP \fIpakketnaam\fP [\fIcontrolebestand\fP]
Som de paden van controlebestanden op die uit \fIpakketnaam\fP op uw systeem
geïnstalleerd werden (sinds dpkg 1.15.4). Indien \fIcontrolebestand\fP
opgegeven werd, toon dan enkel het pad voor dat controlebestand als het
bestaat.

\fBWaarschuwing\fP: dit commando wordt uitgefaseerd, omdat het rechtstreekse
toegang verleent tot de interne database van dpkg. Gelieve in plaats daarvan
over te schakelen op het gebruik van \fB\-\-control\-list\fP en \fB\-\-control\-show\fP
in alle gevallen waarin deze commando's hetzelfde eindresultaat kunnen
geven. Dit commando zal evenwel niet verwijderd worden zolang er nog
minstens één geval is waarin dit commando nodig is (d.w.z. als een
schadelijk postrm\-script van een pakketonderhouder verwijderd moet worden)
en zolang daarvoor geen goede oplossing bestaat.
.TP 
\fB\-S\fP, \fB\-\-search\fP \fIzoekpatroon\-bestandsnaam\fP...
Zoek pakketten die bestanden hebben die overeenkomen met het opgegeven
patroon. Standaard shell\-jokertekens kunnen in het patroon gebruikt worden,
waarbij sterretje (\fB*\fP) en vraagteken (\fB?\fP) met een slash overeenkomen en
backslash (\fB\e\fP) als een maskeerteken (escape\-teken) gebruikt wordt.

Wanneer het eerste teken in het \fIzoekpatroon\-bestandsnaam\fP niet een van de
tekens ‘\fB*[?/\fP’ is, dan zal het beschouwd worden als
deeltekenreeksvergelijking en zal het impliciet geplaatst worden tussen
‘\fB*\fP’ (zoals in \fB*\fP\fIzoekpatroon\-bestandsnaam\fP\fB*\fP). Indien de
daaropvolgende tekenreeks een van de tekens ‘\fB*[?\e\fP’ bevat, dan zal ze
behandeld worden als een glob\-patroon, anders zal een eventuele afsluitende
‘\fB/\fP’ of ‘\fB/.\fP’ verwijderd worden en zal er een letterlijke padopzoeking
uitgevoerd worden.

Dit commando geeft geen extra bestanden weer die door scripts van de
pakketonderhouder aangemaakt werden en ook geen alternatieven.
.TP 
\fB\-p\fP, \fB\-\-print\-avail\fP \fIpakketnaam\fP...
Toon de details in verband met \fIpakketnaam\fP zoals die te vinden zijn in
\fI/var/lib/dpkg/available\fP. Als meerdere \fIpakketnamen\fP opgegeven worden,
worden de gevraagde items uit \fIavailable\fP onderling gescheiden door een
lege regel en weergegeven in dezelfde volgorde als die waarin de lijst
argumenten opgegeven werd.

Gebruikers van frontends die op APT gebaseerd zijn moeten in de plaats
daarvan \fBapt\-cache show\fP \fIpakketnaam\fP gebruiken, aangezien het bestand
\fIavailable\fP enkel up\-to\-date gehouden wordt als men \fBdselect\fP gebruikt.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Toon info over het gebruik en sluit af.
.TP 
\fB\-\-version\fP
Toon de versie en sluit af.
.
.SH OPTIES
.TP 
\fB\-\-admindir=\fP\fImap\fP
Wijzig de locatie van de database van \fBdpkg\fP. De standaardlocatie is
\fI%ADMINDIR%\fP.
.TP 
\fB\-\-load\-avail\fP
Laad ook het bestand available bij het gebruik van de commando's \fB\-\-show\fP
en \fB\-\-list\fP. Standaard doorzoeken die nu enkel het bestand status (sinds
dpkg 1.16.2).
.TP 
\fB\-f\fP, \fB\-\-showformat=\fP\fIindeling\fP
Deze optie wordt gebruikt om op te geven in welke indeling \fB\-\-show\fP zijn
uitvoer moet produceren. De indeling is een tekenreeks die vorm geeft aan de
uitvoer die voor elk opgesomd pakket gegenereerd wordt.

In de indelingstekenreeks markeert “\fB\e\fP” een stuurcode:

.nf
    \fB\en\fP  regeleinde
    \fB\er\fP  wagenterugloop
    \fB\et\fP  tab
.fi

“\fB\e\fP” voor elk ander letterteken onderdrukt de eventuele bijzondere
betekenis van dat navolgende teken, hetgeen van nut is voor “\fB\e\fP” en
“\fB$\fP”.

Pakketinformatie kan ingevoegd worden door variabeleverwijzingen naar
pakketvelden toe te voegen met behulp van de syntaxis
“\fB${\fP\fIveld\fP[\fB;\fP\fIbreedte\fP]\fB}\fP”. Velden worden rechts uitgelijnd
weergegeven tenzij een negatieve breedte opgegeven werd. In dat geval wordt
links uitgelijnd. De volgende \fIveld\fPen worden herkend, maar zijn niet
noodzakelijk aanwezig in het statusbestand (enkel interne velden en velden
die in het binaire pakket opgeslagen worden komen er in terecht):

.nf
    \fBArchitecture\fP (architectuur)
    \fBBugs\fP (bugs)
    \fBConffiles\fP (configuratiebestanden) (intern)
    \fBConfig\-Version\fP (configuratieversie) (intern)
    \fBConflicts\fP (is tegenstrijdig met)
    \fBBreaks\fP (maakt defect)
    \fBDepends\fP (vereist)
    \fBDescription\fP (beschrijving)
    \fBEnhances\fP (biedt uitbreiding voor)
    \fBEssential\fP (essentieel)
    \fBFilename\fP (bestandsnaam) (intern, frontend gerelateerd)
    \fBHomepage\fP (homepage)
    \fBInstalled\-Size\fP (geïnstalleerde grootte)
    \fBMD5sum\fP (MD5\-controlesom) (intern, frontend gerelateerd)
    \fBMSDOS\-Filename\fP (MsDos\-bestandsnaam) (intern, frontend gerelateerd)
    \fBMaintainer\fP (onderhouder)
    \fBOrigin\fP (origine)
    \fBPackage\fP (pakket)
    \fBPre\-Depends\fP (heeft als voorafgaande vereiste)
    \fBPriority\fP (prioriteit)
    \fBProvides\fP (voorziet in)
    \fBRecommends\fP (beveelt aan)
    \fBReplaces\fP (vervangt)
    \fBRevision\fP (revisie) (verouderd)
    \fBSection\fP (sectie)
    \fBSize\fP (grootte) (intern, frontend gerelateerd)
    \fBSource\fP (bron)
    \fBStatus\fP (intern)
    \fBSuggests\fP (suggereert)
    \fBTag\fP (gewoonlijk niet in .deb maar in Packages\-bestand van pakketbron)
    \fBTriggers\-Awaited\fP (triggers\-afgewacht) (intern)
    \fBTriggers\-Pending\fP (triggers\-aanhangig) (intern)
    \fBVersion\fP (versie)
.fi

De volgende velden zijn virtueel en worden door \fBdpkg\-query\fP gegenereerd
uit waarden van andere velden (merk op dat zij namen hebben die niet conform
de veldnamen in een controlebestand zijn):
.RS
.TP 
\fBbinary:Package\fP
Het bevat de naam van het binaire pakket met eventueel een
architectuurkwalificatie zoals “libc6:amd64” (sinds dpkg 1.16.2). Er zal een
architectuurkwalificatie gebruikt worden om ervoor te zorgen dat de
pakketnaam niet ambigu kan zijn, bijvoorbeeld als het pakket een veld
\fBMulti\-Arch\fP met als waarde \fBsame\fP heeft of als het pakket bedoeld is voor
een vreemde architectuur.
.TP 
\fBbinary:Summary\fP
Het bevat de korte beschrijving van het pakket (sinds dpkg 1.16.2).
.TP 
\fBdb:Status\-Abbrev\fP
Het bevat de verkorte pakketstatus (als drie tekens), zoals “ii ” of “iHR”
(sinds dpkg 1.16.2). Zie de beschrijving van het commando \fB\-\-list\fP voor
bijkomende toelichting.
.TP 
\fBdb:Status\-Want\fP
Het bevat de gewenste toestand van het pakket, onderdeel van het veld Status
(sinds dpkg 1.17.11).
.TP 
\fBdb:Status\-Status\fP
Het bevat de pakketstatus uitgedrukt in een woord, onderdeel van het veld
Status (sinds dpkg 1.17.11).
.TP 
\fBdb:Status\-Eflag\fP
Het bevat de status\-foutvlag van het pakket, onderdeel van het veld Status
(sinds dpkg 1.17.11).
.TP 
\fBsource:Package\fP
Het bevat de naam van het broncodepakket van dit binaire pakket (sinds dpkg
1.16.2).
.TP 
\fBsource:Version\fP
Het bevat het versienummer van het broncodepakket van dit binaire pakket
(sinds dpkg 1.16.2).
.RE
.IP
De standaard indelingstekenreeks is
“\fB${binary:Package}\et${Version}\en\fP”. In feite kunnen ook alle andere
velden die in het statusbestand te vinden zijn (d.w.z. door de gebruiker
gedefinieerde velden) opgevraagd worden. Zij zullen evenwel als zodanig
weergegeven worden, zonder conversie of foutcontrole. Om de naam van de
onderhouder van \fBdpkg\fP en de geïnstalleerde versie te bekomen, kunt u het
volgende commando uitvoeren:

.nf
  \fBdpkg\-query \-W \-f='${binary:Package} ${Version}\et${Maintainer}\en' dpkg\fP
.fi
.
.SH AFSLUITSTATUS
.TP 
\fB0\fP
De gevraagde opzoeking werd succesvol uitgevoerd.
.TP 
\fB1\fP
De gevraagde opzoeking mislukte volledig of gedeeltelijk ten gevolge van het
feit dat een bestand of een pakket niet gevonden werd (behalve bij
\fB\-\-control\-path\fP, \fB\-\-control\-list\fP en \fB\-\-control\-show\fP waarvoor dit soort
fouten fataal is).
.TP 
\fB2\fP
Fatale of onherstelbare fout die te wijten is aan ongeldig gebruik van de
commandoregel of aan interacties met het systeem, zoals het benaderen van de
database, het toewijzen van geheugen, enz.
.
.SH OMGEVING
.TP 
\fBDPKG_ADMINDIR\fP
Indien dit ingesteld werd en de optie \fB\-\-admindir\fP niet gebruikt werd, zal
dit gebruikt worden als de datamap voor \fBdpkg\fP.
.TP 
\fBCOLUMNS\fP
Deze instelling wijzigt de uitvoer van de optie \fB\-\-list\fP door de breedte
van de uitvoer ervan aan te passen.
.
.SH "ZIE OOK"
\fBdpkg\fP(1).

