.\" dpkg manual page - deb-src-control(5)
.\"
.\" Copyright © 2010 Oxan van Leeuwen <oxan@oxanvanleeuwen.nl>
.\" Copyright © 2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH deb\-src\-control 5 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
deb\-src\-control \- Dateiformat der Hauptsteuerdatei von Debian\-Quellpaketen
.
.SH ÜBERSICHT
debian/control
.
.SH BESCHREIBUNG
Jedes Debian\-Quellpaket enhält die Hauptsteuerdatei »control«, die
mindestens zwei Absätze enthält, die durch eine Leerzeile getrennt
werden. Der erste Absatz führt alle allgemeinen Informationen über das
Quellpaket auf, während jeder folgende Absatz genau ein Binärpaket
beschreibt. Jeder Absatz besteht aus mindestens einem Feld. Ein Feld beginnt
mit einem Feldnamen, wie \fBPackage\fP oder \fBSection\fP (Groß\-/Kleinschreibung
egal), gefolgt von einem Doppelpunkt, dem Inhalt des Feldes und einem
Zeilenumbruch. Mehrzeilige Felder sind auch erlaubt, aber jede ergänzende
Zeile ohne Feldnamen sollte mit mindestens einem Leerzeichen beginnen. Der
Inhalt des mehrzeiligen Feldes wird durch die Werkzeuge im Allgemeinen zu
einer Zeile zusammengeführt (das Feld \fBDescription\fP ist eine Ausnahme,
siehe unten). Um Leerzeilen in ein mehrzeiliges Feld einzufügen, verwenden
Sie einen Satzpunkt nach dem Leerzeichen. Zeilen, die mit ‚\fB#\fP’ beginnen,
werden als Kommentare betrachtet.
.
.SH QUELLPAKET\-FELDER
.TP 
\fBSource:\fP \fIQuellpaketname\fP (verpflichtend)
Der Wert dieses Feldes ist der Name des Quellpakets und sollte mit dem Namen
des Quellpakets in der Datei debian/changelog übereinstimmen. Ein Paketname
darf nur aus Kleinbuchstaben (a\-z), Ziffern (0\-9), Plus\- (+) und
Minuszeichen (\-) und Satzpunkten (.) bestehen. Paketnamen müssen mindestens
zwei Zeichen lang sein und mit einem alphanumerischen Zeichen beginnen.

.TP 
\fBMaintainer:\fP \fIVollständiger\-Name\-und\-E\-Mail\fP (empfohlen)
Sollte in dem Format »Joe Bloggs <jbloggs@foo.com>« sein und
verweist auf die Person, die derzeit das Paket betreut, im Gegensatz zum
Autor der Software, die paketiert wurde, oder dem ursprünglichen Paketierer.

.TP 
\fBUploaders:\fP\fI Vollständiger\-Name\-und\-E\-Mail\fP
Listet die Namen und E\-Mail\-Adressen der Ko\-Betreuer des Pakets auf, im
gleichen Format wie das Feld \fBMaintainer\fP. Mehrere Ko\-Betreuer sollten
durch Kommata getrennt werden.

.TP 
\fBStandards\-Version:\fP \fI Versionszeichenkette\fP
Dies dokumentiert die neuste Version der Standards der Distribution, an den
sich das Paket hält.

.TP 
\fBHomepage:\fP\fI URL\fP
Die URL des Original\- (Upstream\-)Projekts.

.TP 
\fBBugs:\fP\fI URL\fP
Die \fIURL\fP der Fehlerdatenbank für dieses Paket. Das derzeit verwendete
Format ist \fIBTS\-Art\fP\fB://\fP\fIBTS\-Adresse\fP wie in
\fBdebbugs://bugs.debian.org\fP. Dieses Feld wird normalerweise nicht benötigt.

.TP 
\fBVcs\-Arch*:\fP\fI URL\fP
.TQ
\fBVcs\-Bzr:\fP\fI URL\fP
.TQ
\fBVcs\-Cvs:\fP\fI URL\fP
.TQ
\fBVcs\-Darcs:\fP\fI URL\fP
.TQ
\fBVcs\-Git:\fP\fI URL\fP
.TQ
\fBVcs\-Hg:\fP\fI URL\fP
.TQ
\fBVcs\-Mtn:\fP\fI URL\fP
.TQ
\fBVcs\-Svn:\fP\fI URL\fP
Die \fIURL\fP des Versionskontrollsystem\-Depots, das für die Betreuung des
Pakets verwandt wird. Derzeit werden \fBArch\fP, \fBBzr\fP (Bazaar), \fBCvs\fP,
\fBDarcs\fP, \fBGit\fP, \fBHg\fP (Mercurial), \fBMtn\fP (Monotone) und \fBSvn\fP
(Subversion) unterstützt. Normalerweise zeigt dieses Feld auf die neuste
Version des Pakets, wie den Hauptzweig oder den Trunk.

.TP 
\fBVcs\-Browser:\fP\fI URL\fP
Die \fIURL\fP der Webschnittstelle, um das Versionskontrollsystem\-Depot
anzuschauen.

.TP 
\fBOrigin:\fP\fI Name\fP
Der Name der Distribution, aus der dieses Paket ursprünglich stammt. Dieses
Feld wird normalerweise nicht benötigt.

.TP 
\fBSection:\fP\fI Sektion\fP
Dies ist ein allgemeines Feld, das dem Paket eine Kategorie gibt, basierend
auf der Software, die es installiert. Einige übliche Sektionen sind
\fButils\fP, \fBnet\fP, \fBmail\fP, \fBtext\fP, \fBx11\fP usw.

.TP 
\fBPriority:\fP\fI Priorität\fP
Setzt die Bedeutung dieses Pakets in Bezug zu dem Gesamtsystem. Übliche
Prioritäten sind \fBrequired\fP, \fBstandard\fP, \fBoptional\fP, \fBextra\fP usw.

Die Felder \fBSection\fP und \fBPriority\fP haben eine definierte Menge an Werten,
abhängig von den jeweiligen Distributionsrichtlinien.

.TP 
\fBBuild\-Depends:\fP\fI Paketliste\fP
Eine Liste der Pakete, die installiert und konfiguriert sein müssen, um das
Paket aus den Quellen zu bauen. Diese Abhängigkeiten müssen erfüllt wein,
wenn binäre architekturabhängige und unabhängige und Quellpakete gebaut
werden. Die Aufnahme einer Abhängigkeit in diese Liste hat nicht den
gleichen Effekt wie die Aufnahme in \fBBuild\-Depends\-Arch\fP und
\fBBuild\-Depends\-Indep\fP, da die Abhängigkeit auch beim Bau des Quellpaketes
erfüllt sein muss.
.
.TP 
\fBBuild\-Depends\-Arch:\fP\fI Paketliste\fP
Identisch zu \fBBuild\-Depends\fP, wird aber nur zum Bau der
architekturabhängigen Pakete benötigt. In diesem Fall sind die
\fBBuild\-Depends\fP auch installiert. Dieses Feld wurde seit Dpkg 1.16.4
unterstützt; um mit älteren Dpkg\-Versionen zu bauen, sollte stattdessen
\fBBuild\-Depends\fP verwandt werden.

.TP 
\fBBuild\-Depends\-Indep:\fP\fI Paketliste\fP
Identisch zu \fBBuild\-Depends\fP, wird aber nur zum Bau der
architekturunabhängigen Pakete benötigt. In diesem Fall sind die
\fBBuild\-Depends\fP auch installiert.

.TP 
\fBBuild\-Conflicts:\fP\fI Paketliste\fP
Eine Liste von Paketen, die beim Bau des Pakets nicht installiert sein
sollten, beispielsweise da sie mit dem verwandten Bausystem in Konflikt
geraten. Die Aufnahme einer Abhängigkeit in diese Liste hat den gleichen
Effekt wie die Aufnahme in \fBBuild\-Conflicts\-Arch\fP und
\fBBuild\-Conflicts\-Indep\fP mit dem zusätzlichen Effekt, dass es für reine
Quellen\-Bauten verwandt wird.

.TP 
\fBBuild\-Conflicts\-Arch:\fP\fI Paketliste\fP
Identisch zu \fBBuild\-Conflicts\fP, aber nur beim Bau der architekturabhängigen
Pakete. Dieses Feld wird seit Dpkg 1.16.4 unterstützt; um mit älteren
Dpkg\-Versionen zu bauen, sollte stattdessen \fBBuild\-Conflicts\fP verwandt
werden.

.TP 
\fBBuild\-Conflicts\-Indep:\fP\fI Paketliste\fP
Identisch zu \fBBuild\-Conflicts\fP, wird aber nur zum Bau der
architekturunabhängigen Pakete benötigt.

.PP
Die Syntax der Felder \fBBuild\-Depends\fP, \fBBuild\-Depends\-Arch\fP und
\fBBuild\-Depends\-Indep\fP ist eine Liste von Gruppen von alternativen
Paketen. Jede Gruppe ist eine Liste von durch vertikale Striche (oder
„Pipe“\-Symbole) ‚\fB|\fP’ getrennten Paketen. Die Gruppen werden durch Kommata
getrennt. Kommata müssen als „UND“, vertikale Striche als „ODER“ gelesen
werden, wobei die vertikalen Striche stärker binden. Jeder Paketname wird
optional von einer Architektur\-Spezifikation gefolgt, die nach einem
Doppelpunkt ‚\fB:\fP’ angehängt wird, optional gefolgt von einer
Versionsnummer\-Spezifikation in Klammern, einer Architekturspezifikation in
eckigen Klammern und einer Einschränkungsformel, die aus einer oder mehr
Listen von Profilnamen in spitzen Klammern besteht.

Syntaxtisch werden die Felder \fBBuild\-Conflicts\fP, \fBBuild\-Conflicts\-Arch\fP
und \fBBuild\-Conflicts\-Indep\fP durch eine Komma\-separierte Liste von
Paketnamen dargestellt, wobei das Komma als „UND“ verstanden wird. Die
Angabe alternativer Pakete mit dem „Pipe“\-Symbol wird nicht
unterstützt. Jedem Paketnamen folgt optional eine Versionnummerangabe in
Klammern, eine Architekturspezifikation in eckigen Klammern und einer
Einschränkungsformel, die aus einer oder mehr Listen von Profilnamen in
spitzen Klammern besteht.

Eine Architektur\-Spezifikation kann ein echter Debian\-Architekturname sein
(seit Dpkg 1.16.5), \fBany\fP (seit Dpkg 1.16.2) oder \fBnative\fP (seit Dpkg
1.16.5). Falls er fehlt, ist die Vorgabe für das Feld \fBBuild\-Depends\fP die
aktuelle Host\-Architektur, die Vorgabe für das Feld \fBBuild\-Conflicts\fP ist
\fBany\fP. Jeder echte Debian\-Architekturname passt genau auf diese Architektur
für diesen Paketnamen, \fBany\fP passt auf jede Architektur für diesen
Paketnamen, falls das Paket mit \fBMulti\-Arch: allowed\fP markiert ist, und
\fBnative\fP passt auf die aktuelle Bau\-Architektur, falls das Paket nicht mit
\fBMulti\-Arch: foreign\fP markiert ist.

Eine Versionsnummer kann mit ‚\fB>>\fP’ beginnen, in diesem Falle
passen alle neueren Versionen, und kann die Debian\-Paketrevision (getrennt
durch einen Bindestrich) enthalten oder auch nicht. Akzeptierte
Versionsbeziehungen sind ‚\fB>>\fP’ für größer als, ‚\fB<<\fP’ für
kleiner als, ‚\fB>=\fP’ für größer als oder identisch zu, ‚\fB<=\fP’ für
kleiner als oder identisch zu und ‚\fB=\fP’ für identisch zu.

Eine Architekturspezifikation besteht aus einer oder mehreren durch
Leerraumzeichen getrennten Architekturnamen. Jedem Namen darf ein
Ausrufezeichen vorangestellt werden, das „NICHT“ bedeutet.

Eine Einschränkungsformel besteht aus einer oder mehrerer durch Leerraum
getrennten Einschränkungslisten. Jede Einschränkungsliste wird in spitze
Klammern eingeschlossen. Einträge in den Einschränkungslisten sind
Bauprofilnamen, getrennt durch Leerraum. Diesen Listen kann ein
Ausrufezeichen vorangestellt werden, das „NICHT“ bedeutet. Eine
Einschränkungsformel stellt einen Ausdruck in einer disjunkte Normalform
dar.

Beachten Sie, dass die Abhängigkeiten von Paketen aus der Menge der
\fBbuild\-essential\fP entfallen kann und die Angabe von Baukonflikten gegen sie
nicht möglich ist. Eine Liste dieser Pakete befindet sich im Paket
build\-essential.


.SH BINÄRPAKET\-FELDER

.LP
Beachten Sie, dass die Felder \fBPriority\fP, \fBSection\fP und \fBHomepage\fP sich
auch im Binärprogrammabsatz befinden können, um die globalen Werte des
Quellpakets zu überschreiben.

.TP 
\fBPackage:\fP \fIBinärpaketname\fP (verpflichtend)
Dieses Feld wird zur Angabe des Binärpaketnamens verwandt. Es gelten die
gleichen Einschränkungen wie beim Quellpaketnamen.

.TP 
\fBArchitecture:\fP \fIarch\fP|\fBall\fP|\fBany\fP (verpflichtend)
Die Architektur gibt an, auf welcher Art von Hardware dieses Paket
läuft. Bei Paketen, die auf allen Architekturen laufen, verwenden Sie den
Wert \fBany\fP. Für Pakete, die architekturunabhängig sind, wie Shell\- und
Perl\-Skripte oder Dokumentation, verwenden Sie den Wert \fBall\fP. Um das Paket
für einen bestimmten Satz von Architekturen zu begrenzen, geben Sie die
durch Leerzeichen getrennten Namen der Architekturen an. Es ist auch
möglich, Platzhalter für Architekturen in dieser Liste anzugeben (lesen Sie
\fBdpkg\-architecture\fP(1) für weitere Informationen dazu).

.TP 
\fBBuild\-Profiles:\fP \fIEinschränkungsformel\fP
Dieses Feld legt die Bedingungen fest, zu denen dieses Binärpaket (nicht)
baut. Um diese Bedingung auszudrücken, wird die Einschränkungsformelsyntax
aus dem Feld \fBBuild\-Depends\fP verwandt.

Falls der Absatz eines binären Pakets dieses Feld nicht enthält, dann
bedeutet dies implizit, dass es mit allen Bauprofilen (darunter auch keinem)
baut.

Mit anderen Worten: Falls der Absatz eines Binärpaketes mit einem nicht
leeren Feld \fBBuild\-Profiles\fP kommentiert wird, dann wird dieses Binärpaket
erstellt, falls und nur falls der Ausdruck in konjunktiver Normalform sich
auf »wahr« berechnet.

.TP 
\fBPackage\-Type:\fP \fBdeb\fP|\fBudeb\fP
Dieses Feld definiert die Art des Pakets. \fBudeb\fP ist für größenbegrenzte
Pakete, wie sie vom Debian\-Installer verwandt werden. \fBdeb\fP ist der
Standardwert, er wird angenommen, falls das Feld fehlt. Weitere Typen
könnten in der Zukunft hinzugefügt werden.

.TP 
\fBSubarchitecture:\fP \fI Wert\fP
.TQ
\fBKernel\-Version:\fP \fI Wert\fP
.TQ
\fBInstaller\-Menu\-Item:\fP \fI Wert\fP
Diese Felder werden im Debian\-Installer verwandt und werden normalerweise
nicht benötigt. Lesen Sie /usr/share/doc/debian\-installer/devel/modules.txt
aus dem Paket \fBdebian\-installer\fP für weitere Informationen über sie.

.TP 
\fBEssential:\fP \fByes\fP|\fBno\fP
.TQ
\fBBuild\-Essential:\fP \fByes\fP|\fBno\fP
.TQ
\fBMulti\-Arch:\fP \fBsame\fP|\fBforeign\fP|\fBallowed\fP|\fBno\fP
.TQ
\fBTag:\fP \fI Liste\-von\-Markierungen\fP
.TQ
\fBDescription:\fP \fIKurzbeschreibung\fP (empfohlen)
Diese Felder sind in der Handbuchseite \fBdeb\-control\fP(5) beschrieben, da sie
wörtlich in die control\-Datei des Binärpakets kopiert werden.

.TP 
\fBDepends:\fP \fI Paketliste\fP
.TQ
\fBPre\-Depends:\fP \fI Paketliste\fP
.TQ
\fBRecommends:\fP \fI Paketliste\fP
.TQ
\fBSuggests:\fP \fI Paketliste\fP
.TQ
\fBBreaks:\fP \fI Paketliste\fP
.TQ
\fBEnhances:\fP \fI Paketliste\fP
.TQ
\fBReplaces:\fP \fIPaketliste\fP
.TQ
\fBConflicts:\fP \fI Paketliste\fP
.TQ
\fBProvides:\fP \fI Paketliste\fP
.TQ
\fBBuilt\-Using:\fP \fI Paketliste\fP
Diese Felder deklarieren die Beziehungen zwischen Paketen. Sie werden in der
Handbuchseite \fBdeb\-control\fP(5) beschrieben.

.SH "BENUTZERDEFINIERTE FELDER"
Es ist erlaubt, zusätzliche benutzerdefinierte Felder zu der Steuerdatei
hinzuzufügen. Die Werkzeuge werden diese Felder ignorieren. Falls Sie
möchten, dass diese Felder in die Ausgabedateien, wie das Binärpaket,
rüberkopiert werden sollen, müssen Sie ein angepasstes Namensschema
verwenden: Die Felder sollten mit einem \fBX\fP, gefolgt von Null oder mehreren
Buchstaben aus \fBBCS\fP und einem Gedankenstrich, beginnen.

.TP 
\fBB\fP
Das Feld wird in der Steuerdatei des Binärpakets auftauchen, siehe
\fBdeb\-control\fP(5).
.TP 
\fBS\fP
Das Feld wird in der Steuerdatei des Quellpakets auftauchen, siehe
\fBdsc\fP(5).
.TP 
\fBC\fP
Das Feld wird in der Steuerdatei des Uploads (.changes) auftauchen, siehe
\fBdeb\-changes\fP(5).

.P
Beachten Sie, dass die Präfixe \fBX\fP[\fBBCS\fP]\fB\-\fP abgeschnitten werden, wenn
die Felder in die Ausgabedateien rüberkopiert werden. Ein Feld
\fBXC\-Approved\-By\fP wird als \fBApproved\-By\fP in der .changes\-Datei und nicht in
der Steuerdatei des Binär\- und Quellpakets auftauchen.

Beachten Sie, dass diese Benutzer\-definierten Felder den globalen Namensraum
nutzen werden und somit in der Zukunft mit offiziell erkannten Feldern
kollidieren könnten. Um solche möglichen Situationen zu vermeiden, können
Sie den Feldern \fBPrivate\-\fP, wie in \fBXB\-Private\-Neues\-Feld\fP, voranstellen.

.SH BEISPIEL
.\" .RS
.nf
# Kommentar
Source: dpkg
Section: admin
Priority: required
Maintainer: Dpkg Developers <debian\-dpkg@lists.debian.org>
# dieses Feld wird in das Binär\- und Quellpaket kopiert
XBS\-Upstream\-Release\-Status: stable
Homepage: https://wiki.debian.org/Teams/Dpkg
Vcs\-Browser: https://anonscm.debian.org/cgit/dpkg/dpkg.git
Vcs\-Git: https://anonscm.debian.org/git/dpkg/dpkg.git
Standards\-Version: 3.7.3
Build\-Depends: pkg\-config, debhelper (>= 4.1.81),
 libselinux1\-dev (>= 1.28\-4) [!linux\-any]

Package: dpkg\-dev
Section: utils
Priority: optional
Architecture: all
# dies ist ein spezielles Feld im Binärpaket
XB\-Mentoring\-Contact: Raphael Hertzog <hertzog@debian.org>
Depends: dpkg (>= 1.14.6), perl5, perl\-modules, cpio (>= 2.4.2\-2),
 bzip2, lzma, patch (>= 2.2\-1), make, binutils, libtimedate\-perl
Recommends: gcc | c\-compiler, build\-essential
Suggests: gnupg, debian\-keyring
Conflicts: dpkg\-cross (<< 2.0.0), devscripts (<< 2.10.26)
Replaces: manpages\-pl (<= 20051117\-1)
Description: Debian package development tools
 This package provides the development tools (including dpkg\-source)
 required to unpack, build and upload Debian source packages.
 .
 Most Debian source packages will require additional tools to build;
 for example, most packages need make and the C compiler gcc.
.fi


.\" .RE
.SH "SIEHE AUCH"
\fBdeb\-control\fP(5), \fBdeb\-version\fP(5), \fBdpkg\-source\fP(1)
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2016 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
