#ifndef _MCAST_H_
#define _MCAST_H_

#include <time.h>

//#define DEBUG
//#define CHECKSUM

#undef BUFSIZ
#define BUFSIZ 51200

typedef struct SynPacket {
  unsigned char header;
  unsigned char type;
  long value;
} SynPacket;

typedef struct DataPacket {
  SynPacket header;
  int ndata;
  char data[BUFSIZ];
#ifdef CHECKSUM
  unsigned char checksum[16];
#endif
} DataPacket;

#define HEADER 0xFE
#define TYPE_SEQUENCE_NUMBER 0x01
#define TYPE_VOLUME_SIZE 0x02
#define TYPE_RETURN_CODE 0x03

#define SUCCESS 0x00
#define FAILED  0xFF

/**** Following are the definitions used in partimage *****/

/* defined in client/partimage.h */
typedef unsigned char BYTE; // 8 bits
typedef unsigned short int WORD; // 16 bits
typedef unsigned long int DWORD; // 32 bits
typedef unsigned long long int QWORD; // 64 bits

#define MAGIC_BEGIN_VOLUME      "PaRtImAgE-VoLuMe"
#define MAX_DESCRIPTION         4096
#define MAX_HOSTNAMESIZE        128
#define MAX_DEVICENAMELEN       512

/* defined in share/common.h */
#define MAX_UNAMEINFOLEN 65 //SYS_NMLN

struct CVolumeHeader // size must be 512 (adjust the reserved data)
{
  char szMagicString[32];
  char szVersion[64]; // version of the image file
  DWORD dwVolumeNumber;
  QWORD qwIdentificator; // to avoid using volumes from differents image files on restore
  
  unsigned char cReserved[404]; // Adjust to fit with total header size
} __attribute__ ((packed));

struct CMainHeader // size must be 16384 (adjust the reserved data)
{
  char szFileSystem[512]; // ext2fs, ntfs, reiserfs, ...
  char szPartDescription[MAX_DESCRIPTION]; // user description of the partition
  char szOriginalDevice[MAX_DEVICENAMELEN]; // original partition name
  char szFirstImageFilepath[4095]; //MAXPATHLEN]; // for splitted image files
  
  // system and hardware infos
  char szUnameSysname[MAX_UNAMEINFOLEN];
  char szUnameNodename[MAX_UNAMEINFOLEN];
  char szUnameRelease[MAX_UNAMEINFOLEN];
  char szUnameVersion[MAX_UNAMEINFOLEN];
  char szUnameMachine[MAX_UNAMEINFOLEN];

  DWORD dwCompression; // COMPRESS_XXXXXX
  DWORD dwMainFlags;
  struct tm dateCreate; // date of image creation
  QWORD qwPartSize; // size of the partition in bytes
  char szHostname[MAX_HOSTNAMESIZE];
  char szVersion[64]; // version of the image file

  // MBR backup
  DWORD dwMbrCount; // how many MBR are saved in the image file
  DWORD dwMbrSize; // size of a MBR record (allow to change the size in the next versions)

  // future encryption support
  DWORD dwEncryptAlgo; // algo used to encrypt data
  char cHashTestKey[16]; // used to test the password without giving it
  
  // reserved for future use (save DiskLabel, Extended partitions, ...)
  DWORD dwReservedFuture000;
  DWORD dwReservedFuture001;
  DWORD dwReservedFuture002;
  DWORD dwReservedFuture003;
  DWORD dwReservedFuture004;
  DWORD dwReservedFuture005;
  DWORD dwReservedFuture006;
  DWORD dwReservedFuture007;
  DWORD dwReservedFuture008;
  DWORD dwReservedFuture009;

  BYTE cReserved[6524]; // Adjust to fit with total header size
} __attribute__ ((packed));

struct CMainTail // size must be 16384 (adjust the reserved data)
{
  QWORD qwCRC;
  DWORD dwVolumeNumber;
  
  unsigned char cReserved[16372]; // Adjust to fit with total header size
};
#endif
