#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <openssl/md5.h>
#include <netdb.h>
#include <stdio.h>
#include <unistd.h> /* close */
#include "mcast.h"

/* create the socket and connect to the server */
int tcp_connect_to(char* ipaddr, int port)
{
  int s;
  struct sockaddr_in adr_srvr;

  /* create a server socket address */
  memset(&adr_srvr,0,sizeof(adr_srvr));
  adr_srvr.sin_family = AF_INET;
  adr_srvr.sin_port = htons((u_short)port);
  adr_srvr.sin_addr.s_addr = inet_addr(ipaddr);
  if( adr_srvr.sin_addr.s_addr == INADDR_NONE )
  {
    logit("invalid ip address: %s",ipaddr);
    return -1;
  }

  /* create a TCP/IP socket to use */
  if( (s = socket(AF_INET,SOCK_STREAM,0)) < 0 )
  {
    logit("cannot create socket for %s:%d",ipaddr,port);
    return -1;
  }

  /* connect to the server */
  if( connect(s,(struct sockaddr *)&adr_srvr,sizeof(adr_srvr)) < 0 )
  {
    close(s);
    logit("cannot connect to %s:%d",ipaddr,port);
    return -1;
  }

  return s;
}

int sync_request(int socket, SynPacket* packet) {
  int n = read(socket, packet, sizeof(SynPacket));
  return n;
}

int sync_response(int socket, long value) {
  int n;
  SynPacket packet;

  packet.header=HEADER;
  packet.type=TYPE_RETURN_CODE;
  packet.value=value;
  n = write(socket, &packet, sizeof(SynPacket));
  //logit("sync_response: %d %d",value,n);
  return n;
}

int main(int argc, char *argv[]) {

  int sd, rc, n, cliLen, ssd;
  struct ip_mreq mreq;
  struct sockaddr_in cliAddr; // the multicast address
  struct in_addr mcastAddr;
  struct hostent *h;

  DataPacket packet;
  char buf[BUFSIZ];
  long seqnum=0;

  long volumeSize;

  unsigned char md[17], mdhex[33];

  if(argc!=4) {
    printf("usage : %s <server address> <mcast address> <port> \n",argv[0]);
    exit(0);
  }
  
  /* get mcast address to listen to */
  h=gethostbyname(argv[2]);
  if(h==NULL) {
    logit("%s : unknown group '%s'\n",argv[0],argv[2]);
    exit(1);
  }

  memcpy(&mcastAddr, h->h_addr_list[0],h->h_length);
	  
  /* check given address is multicast */
  if(!IN_MULTICAST(ntohl(mcastAddr.s_addr))) {
     logit("%s : given address '%s' is not multicast",argv[0],
 	  	    inet_ntoa(mcastAddr));
	 exit(1);
  }

  /* create socket */
  sd = socket(AF_INET,SOCK_DGRAM,0);
  if(sd<0) {
      logit("%s : cannot create socket",argv[0]);
      exit(1);
  }
  /* bind port */
  cliAddr.sin_family=AF_INET;
  cliAddr.sin_addr.s_addr=htonl(INADDR_ANY);
  cliAddr.sin_port=htons(atoi(argv[3]));  
  if(bind(sd,(struct sockaddr *) &cliAddr, sizeof(cliAddr))<0) {
    logit("%s : cannot bind port %s",argv[0],argv[3]);
    exit(1);
  }

  /* join multicast group */
  mreq.imr_multiaddr.s_addr=mcastAddr.s_addr;
  mreq.imr_interface.s_addr=htonl(INADDR_ANY);
  
  rc = setsockopt(sd,IPPROTO_IP,IP_ADD_MEMBERSHIP,
						  (void *) &mreq, sizeof(mreq));
  if(rc<0) {
    logit("%s : cannot join multicast group '%s'",argv[0],
	  	   inet_ntoa(mcastAddr));
    exit(1);
  }	
  else {
    logit("%s : listening to mgroup %s:%d",
  	       argv[0],inet_ntoa(mcastAddr), atoi(argv[3]));

    /* sync client */ 
    ssd = tcp_connect_to(argv[1],atoi(argv[3])+1);
    if(ssd < 0) {
      logit("%s : cannot connect to %s:%d\n",argv[0],argv[1],atoi(argv[3])+1);
      close(sd);
      exit(0);
    }

    /* listener loop */
    cliLen=sizeof(cliAddr);
	while((n = recvfrom(sd,&packet,sizeof(DataPacket),0,(struct sockaddr *) &cliAddr, &cliLen))>=0) {

      if( n == sizeof(DataPacket) && 
          packet.header.header == HEADER && 
          packet.header.type == TYPE_SEQUENCE_NUMBER) {

        /* check if this one is the resent packet */
        if( packet.header.value == seqnum ) continue;
        /* check if this one is 'EOMS' packet */
        if( packet.ndata == 4 && packet.data[0]=='E' && 
            packet.data[1]=='O' && packet.data[2]=='M' && 
            packet.data[3]=='S' ) {
		   sync_response(ssd, packet.header.value);
		   break; 
        }
#ifdef CHECKSUM
        /* check the checksum */
        memset(md,0x00,17); 
        if(MD5(packet.data,packet.ndata,md)!=NULL) {
          char *md_p = md; char *chksum_p = packet.checksum;
          int i=0;
          for(i=0;i<16 && (*(md_p+i)==*(chksum_p+i)); i++) ;
          if(i!=16) {
  #ifdef DEBUG
            memset(mdhex,0x00,33);
            md5hex(packet.checksum,mdhex);
            logit("checksum missmatch: %s",mdhex);
  #endif
            continue;
          }
        }        
#endif
        /* write to standout */
#ifdef DEBUG
        memset(mdhex,0x00,33);
  #ifdef CHECKSUM
        md5hex(packet.checksum,mdhex);
  #endif
	    logit("seqnum: %d data: %d md5hex: %s",seqnum,packet.ndata,mdhex);
#endif
        seqnum = packet.header.value;
        full_write(1,packet.data,packet.ndata);
        rc = sync_response(ssd,seqnum);
        if(rc<0) { logit("sync_response failed! seqnum=%d",seqnum); break; }

      } // end of if n == sizeof(DataPacket)

    }/* end of listener loop */
  }
  // leave the multicast group
  setsockopt(sd,IPPROTO_IP,IP_DROP_MEMBERSHIP, (void *) &mreq, sizeof(mreq));
  close(sd);
  close(ssd);

  return 0;  
}  
