#!/bin/bash
# Author: Steven Shiau <steven _at_ nchc org tw>
# License: GPL

. /opt/drbl/sbin/drbl-conf-functions

# Settings
# try IP from 192.168."100".254
private_IP_alias_eth_def="100"

# functions
USAGE() {
    echo "To start, restart or stop Clonezilla server edition service in DRBL Live environment."
    echo "Usage:"
    echo "$0 {start|stop|restart}"
    echo "start   Start Clonezilla server edition service now"
    echo "stop    Stop Clonezilla server edition service service now"
    echo "restart Restart Clonezilla server edition service service now"
    echo "Example: To start Clonezilla server edition service service in this DRBL Live server"
    echo "$0 start"
}

#################
##### MAIN ######
#################
check_if_root

#
ask_and_load_lang_set
#
if [ $# -ne 1 ]; then
  USAGE
  exit 1
fi

switch=$1

#
if ! is_boot_from_live; then
  [ "$BOOTUP" = "color" ] && $SETCOLOR_FAILURE
  echo "This command $0 is used in DRBL Live environment only!"
  [ "$BOOTUP" = "color" ] && $SETCOLOR_NORMAL
  echo "$msg_program_stop"
  exit 1
fi

case "$switch" in
   "start"|"restart")
     # start drbl live first, which will setup drbl environment
     echo "Checking if DRBL related sevices are started or not..."
     dhcpd_pid=`pidof dhcpd3`
     tftpd_pid=`pidof in.tftpd`
     unfsd_pid=`pidof unfsd`
     nfsd_pid=`pidof nfsd`
     if [ -z "$dhcpd_pid" -o -z "$tftpd_pid" ] || [ -z "$unfsd_pid" -a -z "$nfsd_pid" ]; then
       echo "$msg_delimiter_star_line"
       echo "$msg_drbl_env_is_not_ready_now_config"
       echo $msg_this_might_take_several_minutes
       echo -n $msg_press_enter_to_continue
       read
       echo "$msg_delimiter_star_line"
       drbl-live.sh --prepare-ocsroot --skip-pause-in-the-end start
     fi

     echo "$msg_delimiter_star_line"
     echo "$msg_drbl_env_is_ready"
     echo "$msg_delimiter_star_line"
     sleep 1
     dcs clonezilla-start

     echo "$msg_delimiter_star_line"
     echo "$msg_do_not_close_window_until_clone_finish"
     /bin/bash
     ;;
   "stop")
     drbl-ocs stop
     echo "$msg_delimiter_star_line"
     echo -n $msg_press_enter_to_continue
     read < /dev/stdin
     ;;
esac
